/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.fx.ParticleRenderDispatcher;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.lib.LibObfuscation;

public class FXSparkle
extends EntityFX {
    public static final ResourceLocation particles = new ResourceLocation("botania:textures/misc/particles.png");
    private static Queue<FXSparkle> queuedRenders = new ArrayDeque<FXSparkle>();
    private static Queue<FXSparkle> queuedCorruptRenders = new ArrayDeque<FXSparkle>();
    private float f;
    private float f1;
    private float f2;
    private float f3;
    private float f4;
    private float f5;
    public boolean noClip = false;
    public boolean corrupt = false;
    public boolean fake = false;
    private int multiplier = 2;
    private boolean shrink = true;
    public int particle = 16;
    public boolean tinkle = false;
    public boolean slowdown = true;
    public int currentColor = 0;

    public FXSparkle(World world, double x, double y, double z, float size, float red, float green, float blue, int m) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_70552_h = red;
        this.field_70553_i = green;
        this.field_70551_j = blue;
        this.field_82339_as = 0.5f;
        this.field_70545_g = 0.0f;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.field_70544_f *= size;
        this.field_70547_e = 3 * m;
        this.multiplier = m;
        this.noClip = false;
        this.func_187115_a(0.01f, 0.01f);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
    }

    public static void dispatchQueuedRenders(Tessellator tessellator) {
        ParticleRenderDispatcher.sparkleFxCount = 0;
        ParticleRenderDispatcher.fakeSparkleFxCount = 0;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ConfigHandler.matrixMode ? (ResourceLocation)ReflectionHelper.getPrivateValue(EffectRenderer.class, null, (String[])LibObfuscation.PARTICLE_TEXTURES) : particles);
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (FXSparkle sparkle : queuedRenders) {
            sparkle.renderQueued(tessellator);
        }
        tessellator.func_78381_a();
        ShaderHelper.useShader(ShaderHelper.filmGrain);
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (FXSparkle sparkle : queuedCorruptRenders) {
            sparkle.renderQueued(tessellator);
        }
        tessellator.func_78381_a();
        ShaderHelper.releaseShader();
        queuedRenders.clear();
        queuedCorruptRenders.clear();
    }

    private void renderQueued(Tessellator tessellator) {
        if (this.fake) {
            ++ParticleRenderDispatcher.fakeSparkleFxCount;
        } else {
            ++ParticleRenderDispatcher.sparkleFxCount;
        }
        int part = this.particle + this.field_70546_d / this.multiplier;
        float var8 = (float)(part % 8) / 8.0f;
        float var9 = var8 + 0.124875f;
        float var10 = (float)(part / 8) / 8.0f;
        float var11 = var10 + 0.124875f;
        float var12 = 0.1f * this.field_70544_f;
        if (this.shrink) {
            var12 *= (float)(this.field_70547_e - this.field_70546_d + 1) / (float)this.field_70547_e;
        }
        float var13 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)this.f - field_70556_an);
        float var14 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)this.f - field_70554_ao);
        float var15 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)this.f - field_70555_ap);
        float var16 = 1.0f;
        tessellator.func_178180_c().func_181662_b((double)(var13 - this.f1 * var12 - this.f4 * var12), (double)(var14 - this.f2 * var12), (double)(var15 - this.f3 * var12 - this.f5 * var12)).func_187315_a((double)var9, (double)var11).func_181666_a(this.field_70552_h * var16, this.field_70553_i * var16, this.field_70551_j * var16, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(var13 - this.f1 * var12 + this.f4 * var12), (double)(var14 + this.f2 * var12), (double)(var15 - this.f3 * var12 + this.f5 * var12)).func_187315_a((double)var9, (double)var10).func_181666_a(this.field_70552_h * var16, this.field_70553_i * var16, this.field_70551_j * var16, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(var13 + this.f1 * var12 + this.f4 * var12), (double)(var14 + this.f2 * var12), (double)(var15 + this.f3 * var12 + this.f5 * var12)).func_187315_a((double)var8, (double)var10).func_181666_a(this.field_70552_h * var16, this.field_70553_i * var16, this.field_70551_j * var16, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(var13 + this.f1 * var12 - this.f4 * var12), (double)(var14 - this.f2 * var12), (double)(var15 + this.f3 * var12 - this.f5 * var12)).func_187315_a((double)var8, (double)var11).func_181666_a(this.field_70552_h * var16, this.field_70553_i * var16, this.field_70551_j * var16, 1.0f).func_181675_d();
    }

    public void func_180434_a(VertexBuffer worldRendererIn, Entity p_180434_2_, float f, float f1, float f2, float f3, float f4, float f5) {
        this.f = f;
        this.f1 = f1;
        this.f2 = f2;
        this.f3 = f3;
        this.f4 = f4;
        this.f5 = f5;
        if (this.corrupt) {
            queuedCorruptRenders.add(this);
        } else {
            queuedRenders.add(this);
        }
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187130_j -= 0.04 * (double)this.field_70545_g;
        if (!this.noClip && !this.fake) {
            this.pushOutOfBlocks(this.field_187126_f, (this.func_187116_l().field_72338_b + this.func_187116_l().field_72337_e) / 2.0, this.field_187128_h);
        }
        this.field_187126_f += this.field_187129_i;
        this.field_187127_g += this.field_187130_j;
        this.field_187128_h += this.field_187131_k;
        if (this.slowdown) {
            this.field_187129_i *= 0.9080000019073486;
            this.field_187130_j *= 0.9080000019073486;
            this.field_187131_k *= 0.9080000019073486;
            if (this.field_187132_l) {
                this.field_187129_i *= (double)0.7f;
                this.field_187131_k *= (double)0.7f;
            }
        }
        if (this.fake && this.field_70546_d > 1) {
            this.func_187112_i();
        }
    }

    public void setGravity(float value) {
        this.field_70545_g = value;
    }

    private boolean pushOutOfBlocks(double par1, double par3, double par5) {
        int var7 = MathHelper.func_76128_c((double)par1);
        int var8 = MathHelper.func_76128_c((double)par3);
        int var9 = MathHelper.func_76128_c((double)par5);
        double var10 = par1 - (double)var7;
        double var12 = par3 - (double)var8;
        double var14 = par5 - (double)var9;
        BlockPos bPos = new BlockPos(var7, var8, var9);
        if (!this.field_187122_b.func_175623_d(bPos)) {
            boolean var16 = !this.field_187122_b.func_175677_d(bPos.func_177976_e(), false);
            boolean var17 = !this.field_187122_b.func_175677_d(bPos.func_177974_f(), false);
            boolean var18 = !this.field_187122_b.func_175677_d(bPos.func_177977_b(), false);
            boolean var19 = !this.field_187122_b.func_175677_d(bPos.func_177984_a(), false);
            boolean var20 = !this.field_187122_b.func_175677_d(bPos.func_177978_c(), false);
            boolean var21 = !this.field_187122_b.func_175677_d(bPos.func_177968_d(), false);
            int var22 = -1;
            double var23 = 9999.0;
            if (var16 && var10 < var23) {
                var23 = var10;
                var22 = 0;
            }
            if (var17 && 1.0 - var10 < var23) {
                var23 = 1.0 - var10;
                var22 = 1;
            }
            if (var18 && var12 < var23) {
                var23 = var12;
                var22 = 2;
            }
            if (var19 && 1.0 - var12 < var23) {
                var23 = 1.0 - var12;
                var22 = 3;
            }
            if (var20 && var14 < var23) {
                var23 = var14;
                var22 = 4;
            }
            if (var21 && 1.0 - var14 < var23) {
                var23 = 1.0 - var14;
                var22 = 5;
            }
            float var25 = this.field_187136_p.nextFloat() * 0.05f + 0.025f;
            float var26 = (this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.1f;
            if (var22 == 0) {
                this.field_187129_i = -var25;
                this.field_187130_j = this.field_187131_k = (double)var26;
            }
            if (var22 == 1) {
                this.field_187129_i = var25;
                this.field_187130_j = this.field_187131_k = (double)var26;
            }
            if (var22 == 2) {
                this.field_187130_j = -var25;
                this.field_187129_i = this.field_187131_k = (double)var26;
            }
            if (var22 == 3) {
                this.field_187130_j = var25;
                this.field_187129_i = this.field_187131_k = (double)var26;
            }
            if (var22 == 4) {
                this.field_187131_k = -var25;
                this.field_187130_j = this.field_187129_i = (double)var26;
            }
            if (var22 == 5) {
                this.field_187131_k = var25;
                this.field_187130_j = this.field_187129_i = (double)var26;
            }
            return true;
        }
        return false;
    }
}

