/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import java.util.List;
import java.util.stream.Collectors;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.common.FMLLog;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.block.ItemBlockFloatingSpecialFlower;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class FloatingFlowerModel
implements IBakedModel,
IResourceManagerReloadListener {
    public static final FloatingFlowerModel INSTANCE = new FloatingFlowerModel();
    private static final String MUNDANE_PREFIX = "botania:shimmeringFlower_";
    private static final Table<IFloatingFlower.IslandType, String, CompositeBakedModel> CACHE = HashBasedTable.create();

    protected static BakedQuad transform(BakedQuad quad, final TRSRTransformation transform) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
        VertexTransformer consumer = new VertexTransformer((IVertexConsumer)builder){

            public void put(int element, float ... data) {
                VertexFormatElement formatElement = DefaultVertexFormats.field_176599_b.func_177348_c(element);
                switch (formatElement.func_177375_c()) {
                    case POSITION: {
                        float[] newData = new float[4];
                        Vector4f vec = new Vector4f(data);
                        transform.getMatrix().transform((Tuple4f)vec);
                        vec.get(newData);
                        this.parent.put(element, newData);
                        break;
                    }
                    default: {
                        this.parent.put(element, data);
                    }
                }
            }
        };
        quad.pipe((IVertexConsumer)consumer);
        return builder.build();
    }

    public void func_110549_a(IResourceManager resourceManager) {
        CACHE.clear();
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing face, long rand) {
        if (state.func_177230_c() != ModBlocks.floatingSpecialFlower && state.func_177230_c() != ModBlocks.floatingFlower) {
            return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a().func_188616_a(state, face, rand);
        }
        IExtendedBlockState realState = (IExtendedBlockState)state;
        IFloatingFlower.IslandType islandType = (IFloatingFlower.IslandType)realState.getValue(BotaniaStateProps.ISLAND_TYPE);
        String identifier = state.func_177230_c() == ModBlocks.floatingSpecialFlower ? (String)realState.getValue(BotaniaStateProps.SUBTILE_ID) : MUNDANE_PREFIX + ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176765_a();
        return this.getModel(islandType, identifier).func_188616_a(state, face, rand);
    }

    private CompositeBakedModel getModel(IFloatingFlower.IslandType islandType, String identifier) {
        IBakedModel flowerModel;
        IBakedModel islandModel;
        ModelManager modelManager = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a();
        if (CACHE.contains((Object)islandType, (Object)identifier)) {
            return (CompositeBakedModel)CACHE.get((Object)islandType, (Object)identifier);
        }
        try {
            islandModel = ModelLoaderRegistry.getModel((ResourceLocation)((ResourceLocation)BotaniaAPIClient.getRegisteredIslandTypeModels().get(islandType))).bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
        }
        catch (Exception e) {
            islandModel = modelManager.func_174951_a();
        }
        if (identifier.startsWith(MUNDANE_PREFIX)) {
            int meta = Integer.parseInt(identifier.substring(identifier.indexOf(MUNDANE_PREFIX) + MUNDANE_PREFIX.length()));
            flowerModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(new ItemStack(ModBlocks.shinyFlower, 1, meta));
        } else {
            ItemStack stack = ItemBlockSpecialFlower.ofType(identifier);
            IBakedModel specialFlowerModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
            flowerModel = specialFlowerModel.func_188617_f().handleItemState(specialFlowerModel, stack, null, null);
        }
        CompositeBakedModel model = new CompositeBakedModel(flowerModel, islandModel);
        FMLLog.info((String)"[Botania]: Cached floating flower model for islandtype %s and flowertype %s", (Object[])new Object[]{islandType, identifier});
        CACHE.put((Object)islandType, (Object)identifier, (Object)model);
        return model;
    }

    public ItemOverrideList func_188617_f() {
        return ItemHandler.INSTANCE;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    private static class ItemHandler
    extends ItemOverrideList {
        private static final ItemHandler INSTANCE = new ItemHandler();

        private ItemHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel model, ItemStack stack, World world, EntityLivingBase entity) {
            IFloatingFlower.IslandType islandType = IFloatingFlower.IslandType.GRASS;
            String identifier = Block.func_149634_a((Item)stack.func_77973_b()) == ModBlocks.floatingSpecialFlower ? ItemBlockFloatingSpecialFlower.getType(stack) : FloatingFlowerModel.MUNDANE_PREFIX + stack.func_77952_i();
            return INSTANCE.getModel(islandType, identifier);
        }
    }

    private static class CompositeBakedModel
    implements IBakedModel {
        private final IBakedModel base;
        private final List<BakedQuad> genQuads;

        public CompositeBakedModel(IBakedModel flower, IBakedModel island) {
            this.base = flower;
            ImmutableList.Builder genBuilder = ImmutableList.builder();
            TRSRTransformation transform = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.2f, 0.0f), null, new Vector3f(0.5f, 0.5f, 0.5f), null));
            for (BakedQuad quad : flower.func_188616_a(null, null, 0L)) {
                genBuilder.add((Object)FloatingFlowerModel.transform(quad, transform));
            }
            for (EnumFacing e : EnumFacing.field_82609_l) {
                genBuilder.addAll((Iterable)flower.func_188616_a(null, e, 0L).stream().map(input -> FloatingFlowerModel.transform(input, transform)).collect(Collectors.toList()));
            }
            genBuilder.addAll((Iterable)island.func_188616_a(null, null, 0L));
            for (EnumFacing e : EnumFacing.field_82609_l) {
                genBuilder.addAll((Iterable)island.func_188616_a(null, e, 0L));
            }
            this.genQuads = genBuilder.build();
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing face, long rand) {
            return this.genQuads;
        }

        public boolean func_177555_b() {
            return this.base.func_177555_b();
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return this.base.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.base.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.base.func_177552_f();
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }
}

