/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.IModelState;
import vazkii.botania.api.state.enums.PylonVariant;
import vazkii.botania.client.model.IPylonModel;

public class ModelPylon
implements IPylonModel {
    private static final Function<ResourceLocation, TextureAtlasSprite> TEXTUREGETTER = input -> Minecraft.func_71410_x().func_147117_R().func_110572_b(input.toString());
    private IBakedModel manaCrystal;
    private IBakedModel manaRingsAndPanes;
    private IBakedModel manaGems;
    private IBakedModel naturaCrystal;
    private IBakedModel naturaRingsAndPanes;
    private IBakedModel naturaGems;
    private IBakedModel gaiaCrystal;
    private IBakedModel gaiaRingsAndPanes;
    private IBakedModel gaiaGems;

    public ModelPylon() {
        try {
            OBJModel model = (OBJModel)OBJLoader.INSTANCE.loadModel(new ResourceLocation("botania:models/block/pylon.obj"));
            IModel manaModel = ((OBJModel)model.retexture(ImmutableMap.of((Object)"#pylon", (Object)"botania:model/pylon"))).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
            IModel naturaModel = ((OBJModel)model.retexture(ImmutableMap.of((Object)"#pylon", (Object)"botania:model/pylon1"))).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
            IModel gaiaModel = ((OBJModel)model.retexture(ImmutableMap.of((Object)"#pylon", (Object)"botania:model/pylon2"))).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
            this.manaCrystal = manaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.naturaCrystal = naturaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.gaiaCrystal = gaiaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.manaRingsAndPanes = manaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal_Ring", (Object)"Ring_Panel01", (Object)"Ring_Panel02", (Object)"Ring_Panel03", (Object)"Ring_Panel04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.naturaRingsAndPanes = naturaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal_Ring", (Object)"Ring_Panel01", (Object)"Ring_Panel02", (Object)"Ring_Panel03", (Object)"Ring_Panel04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.gaiaRingsAndPanes = gaiaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Crystal_Ring", (Object)"Ring_Panel01", (Object)"Ring_Panel02", (Object)"Ring_Panel03", (Object)"Ring_Panel04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.manaGems = manaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Ring_Gem01", (Object)"Ring_Gem02", (Object)"Ring_Gem03", (Object)"Ring_Gem04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.naturaGems = naturaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Ring_Gem01", (Object)"Ring_Gem02", (Object)"Ring_Gem03", (Object)"Ring_Gem04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
            this.gaiaGems = gaiaModel.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Ring_Gem01", (Object)"Ring_Gem02", (Object)"Ring_Gem03", (Object)"Ring_Gem04"), false), Attributes.DEFAULT_BAKED_FORMAT, TEXTUREGETTER);
        }
        catch (Exception e) {
            throw new ReportedException(new CrashReport("Error making pylon submodels for TESR!", (Throwable)e));
        }
    }

    @Override
    public void renderCrystal(PylonVariant variant) {
        switch (variant) {
            case MANA: {
                this.renderModel(this.manaCrystal);
                break;
            }
            case NATURA: {
                this.renderModel(this.naturaCrystal);
                break;
            }
            case GAIA: {
                this.renderModel(this.gaiaCrystal);
            }
        }
    }

    @Override
    public void renderRing(PylonVariant variant) {
        GlStateManager.func_179140_f();
        switch (variant) {
            case MANA: {
                this.renderModel(this.manaRingsAndPanes);
                break;
            }
            case NATURA: {
                this.renderModel(this.naturaRingsAndPanes);
                break;
            }
            case GAIA: {
                this.renderModel(this.gaiaRingsAndPanes);
            }
        }
        GlStateManager.func_179145_e();
    }

    @Override
    public void renderGems(PylonVariant variant) {
        GlStateManager.func_179140_f();
        switch (variant) {
            case MANA: {
                this.renderModel(this.manaGems);
                break;
            }
            case NATURA: {
                this.renderModel(this.naturaGems);
                break;
            }
            case GAIA: {
                this.renderModel(this.gaiaGems);
            }
        }
        GlStateManager.func_179145_e();
    }

    private void renderModel(IBakedModel model) {
        this.renderModel(model, -1);
    }

    private void renderModel(IBakedModel model, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        this.renderQuads(worldrenderer, model.func_188616_a(null, null, 0L), color);
        tessellator.func_78381_a();
    }

    private void renderQuads(VertexBuffer renderer, List<BakedQuad> quads, int color) {
        for (BakedQuad bakedquad : quads) {
            LightUtil.renderQuadColor((VertexBuffer)renderer, (BakedQuad)bakedquad, (int)color);
        }
    }
}

