/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class SpecialFlowerModel
implements IModelCustomData {
    public static final SpecialFlowerModel INSTANCE = new SpecialFlowerModel((ImmutableMap<Optional<String>, ModelResourceLocation>)ImmutableMap.of(), (ImmutableMap<Optional<String>, ModelResourceLocation>)ImmutableMap.of());
    private final ImmutableMap<Optional<String>, ModelResourceLocation> blockModels;
    private final ImmutableMap<Optional<String>, ModelResourceLocation> itemModels;

    public SpecialFlowerModel(ImmutableMap<Optional<String>, ModelResourceLocation> blockModels, ImmutableMap<Optional<String>, ModelResourceLocation> itemModels) {
        this.blockModels = blockModels;
        this.itemModels = itemModels;
    }

    public Collection<ResourceLocation> getDependencies() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)this.blockModels.values());
        builder.addAll((Iterable)this.itemModels.values());
        builder.addAll(BotaniaAPIClient.getRegisteredIslandTypeModels().values());
        return builder.build();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new SpecialFlowerBakedModel(this.blockModels, this.itemModels, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ImmutableMap.Builder blockBuilder = ImmutableMap.builder();
        ImmutableMap.Builder itemBuilder = ImmutableMap.builder();
        for (String string : customData.keySet()) {
            if (!"base".equals(string)) continue;
            blockBuilder.put((Object)Optional.absent(), (Object)this.getLocation((String)customData.get((Object)string)));
        }
        for (Map.Entry entry : BotaniaAPIClient.getRegisteredSubtileBlockModels().entrySet()) {
            blockBuilder.put((Object)Optional.of(entry.getKey()), entry.getValue());
        }
        for (Map.Entry entry : BotaniaAPIClient.getRegisteredSubtileItemModels().entrySet()) {
            itemBuilder.put((Object)Optional.of(entry.getKey()), entry.getValue());
        }
        ImmutableMap blockModels = blockBuilder.build();
        ImmutableMap immutableMap = itemBuilder.build();
        if (blockModels.isEmpty() && immutableMap.isEmpty()) {
            return INSTANCE;
        }
        return new SpecialFlowerModel((ImmutableMap<Optional<String>, ModelResourceLocation>)blockModels, (ImmutableMap<Optional<String>, ModelResourceLocation>)immutableMap);
    }

    private ModelResourceLocation getLocation(String json) {
        JsonElement e = new JsonParser().parse(json);
        if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
            return new ModelResourceLocation(e.getAsString());
        }
        FMLLog.severe((String)"Expect ModelResourceLocation, got: ", (Object[])new Object[]{json});
        return new ModelResourceLocation("builtin/missing", "missing");
    }

    public static class SpecialFlowerBakedModel
    implements IPerspectiveAwareModel {
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final ImmutableMap<Optional<String>, ModelResourceLocation> blockModels;
        private final ImmutableMap<Optional<String>, ModelResourceLocation> itemModels;
        private IBakedModel baseModel;
        private ImmutableMap<String, IBakedModel> bakedBlockModels;
        private ImmutableMap<String, IBakedModel> bakedItemModels;
        private final ItemOverrideList itemHandler = new ItemOverrideList((List)ImmutableList.of()){

            public IBakedModel handleItemState(IBakedModel original, ItemStack stack, World world, EntityLivingBase living) {
                this.refreshBakedModels();
                IBakedModel item = (IBakedModel)bakedItemModels.get((Object)ItemBlockSpecialFlower.getType(stack));
                if (item == null) {
                    item = (IBakedModel)bakedBlockModels.get((Object)ItemBlockSpecialFlower.getType(stack));
                }
                return item == null ? Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a() : item;
            }
        };

        public SpecialFlowerBakedModel(ImmutableMap<Optional<String>, ModelResourceLocation> blockModels, ImmutableMap<Optional<String>, ModelResourceLocation> itemModels, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms) {
            this.blockModels = blockModels;
            this.itemModels = itemModels;
            this.transforms = cameraTransforms;
        }

        private void refreshBakedModels() {
            if (this.baseModel == null) {
                this.baseModel = this.getBlockModel((Optional<String>)Optional.absent());
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry e : this.blockModels.entrySet()) {
                    if (!((Optional)e.getKey()).isPresent()) continue;
                    builder.put(((Optional)e.getKey()).get(), (Object)this.getBlockModel((Optional<String>)((Optional)e.getKey())));
                }
                this.bakedBlockModels = builder.build();
                ImmutableMap.Builder builder2 = ImmutableMap.builder();
                for (Map.Entry e : this.itemModels.entrySet()) {
                    if (!((Optional)e.getKey()).isPresent()) continue;
                    builder2.put(((Optional)e.getKey()).get(), (Object)this.getItemModel((Optional<String>)((Optional)e.getKey())));
                }
                this.bakedItemModels = builder2.build();
            }
        }

        private IBakedModel getBlockModel(Optional<String> opt) {
            ModelResourceLocation loc = (ModelResourceLocation)this.blockModels.get(opt);
            if (loc == null) {
                loc = new ModelResourceLocation("builtin/missing", "missing");
            }
            IModel model = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)loc);
            return model.bake((IModelState)new SimpleModelState(this.transforms), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
        }

        private IBakedModel getItemModel(Optional<String> opt) {
            ModelResourceLocation loc = (ModelResourceLocation)this.itemModels.get(opt);
            if (loc == null) {
                loc = new ModelResourceLocation("builtin/missing", "missing");
            }
            IModel model = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)loc);
            return model.bake((IModelState)new SimpleModelState(this.transforms), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing face, long rand) {
            if (state.func_177230_c() != ModBlocks.specialFlower) {
                return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a().func_188616_a(state, face, rand);
            }
            this.refreshBakedModels();
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            IBakedModel ret = (IBakedModel)this.bakedBlockModels.get(extendedState.getValue(BotaniaStateProps.SUBTILE_ID));
            if (ret == null) {
                ret = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            }
            return ret.func_188616_a(state, face, rand);
        }

        public ItemOverrideList func_188617_f() {
            return this.itemHandler;
        }

        public boolean func_177555_b() {
            this.refreshBakedModels();
            return this.baseModel.func_177555_b();
        }

        public boolean func_177556_c() {
            this.refreshBakedModels();
            return this.baseModel.func_177556_c();
        }

        public boolean func_188618_c() {
            this.refreshBakedModels();
            return this.baseModel.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            this.refreshBakedModels();
            return this.baseModel.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.baseModel.func_177552_f();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE{

            public void func_110549_a(IResourceManager resourceManager) {
            }

            public boolean accepts(ResourceLocation modelLocation) {
                return modelLocation.func_110624_b().equals("botania_special") && (modelLocation.func_110623_a().equals("specialFlower") || modelLocation.func_110623_a().equals("models/block/specialFlower") || modelLocation.func_110623_a().equals("models/item/specialFlower"));
            }

            public IModel loadModel(ResourceLocation modelLocation) throws IOException {
                return SpecialFlowerModel.INSTANCE;
            }
        };

    }
}

