/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.EnumDyeColor;
import vazkii.botania.api.mana.IPoolOverlayProvider;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.PoolVariant;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.handler.MultiblockRenderHandler;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.mana.TilePool;

public class RenderTilePool
extends TileEntitySpecialRenderer<TilePool> {
    public static PoolVariant forceVariant = PoolVariant.DEFAULT;
    public static boolean forceMana = false;
    public static int forceManaNumber = -1;

    public void renderTileEntityAt(TilePool pool, double d0, double d1, double d2, float f, int digProgress) {
        TextureAtlasSprite overlay;
        Block below;
        int cap;
        int color;
        if (!(pool == null || pool.func_145831_w().func_175668_a(pool.func_174877_v(), false) && pool.func_145831_w().func_180495_p(pool.func_174877_v()).func_177230_c() == ModBlocks.pool)) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179091_B();
        float a = MultiblockRenderHandler.rendering ? 0.6f : 1.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
        if (pool == null) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
        } else {
            GlStateManager.func_179137_b((double)d0, (double)d1, (double)d2);
        }
        boolean fab = pool == null ? forceVariant == PoolVariant.FABULOUS : pool.func_145831_w().func_180495_p(pool.func_174877_v()).func_177229_b(BotaniaStateProps.POOL_VARIANT) == PoolVariant.FABULOUS;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (fab) {
            float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
            if (pool != null) {
                time += (float)new Random(pool.func_174877_v().func_177958_n() ^ pool.func_174877_v().func_177956_o() ^ pool.func_174877_v().func_177952_p()).nextInt(100000);
            }
            color = Color.getHSBColor(time * 0.005f, 0.6f, 1.0f).hashCode();
        } else {
            color = pool == null ? EnumDyeColor.WHITE.func_176768_e().field_76291_p : pool.getColor().func_176768_e().field_76291_p;
        }
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(pool == null ? ModBlocks.pool.func_176223_P().func_177226_a(BotaniaStateProps.POOL_VARIANT, (Comparable)((Object)forceVariant)) : pool.func_145831_w().func_180495_p(pool.func_174877_v()));
        int red = (color & 0xFF0000) >> 16;
        int green = (color & 0xFF00) >> 8;
        int blue = color & 0xFF;
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178262_a(model, 1.0f, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)1.5f, (float)0.5f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
        GlStateManager.func_179091_B();
        int mana = pool == null ? forceManaNumber : pool.getCurrentMana();
        int n = cap = pool == null ? -1 : pool.manaCap;
        if (cap == -1) {
            cap = 1000000;
        }
        float waterLevel = (float)mana / (float)cap * 0.4f;
        if (forceMana) {
            waterLevel = 0.4f;
        }
        float s = 0.0625f;
        float v = 0.125f;
        float w = -v * 3.5f;
        if (pool != null && (below = pool.func_145831_w().func_180495_p(pool.func_174877_v().func_177977_b()).func_177230_c()) instanceof IPoolOverlayProvider && (overlay = ((IPoolOverlayProvider)below).getIcon(pool.func_145831_w(), pool.func_174877_v())) != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179118_c();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(a * (float)((Math.sin((double)((float)ClientTickHandler.ticksInGame + f) / 20.0) + 1.0) * 0.3 + 0.2)));
            GlStateManager.func_179109_b((float)-0.5f, (float)-1.4300001f, (float)-0.5f);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)s, (float)s, (float)s);
            this.renderIcon(0, 0, overlay, 16, 16, 240);
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        if (waterLevel > 0.0f) {
            s = 0.0546875f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179118_c();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
            GlStateManager.func_179109_b((float)w, (float)(-1.0f - (0.43f - waterLevel)), (float)w);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)s, (float)s, (float)s);
            ShaderHelper.useShader(ShaderHelper.manaPool);
            this.renderIcon(0, 0, MiscellaneousIcons.INSTANCE.manaWater, 16, 16, 240);
            ShaderHelper.releaseShader();
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        forceVariant = PoolVariant.DEFAULT;
        forceMana = false;
        forceManaNumber = -1;
    }

    public void renderIcon(int par1, int par2, TextureAtlasSprite par3Icon, int par4, int par5, int brightness) {
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tessellator.func_178180_c().func_181662_b((double)(par1 + 0), (double)(par2 + par5), 0.0).func_187315_a((double)par3Icon.func_94209_e(), (double)par3Icon.func_94210_h()).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(par1 + par4), (double)(par2 + par5), 0.0).func_187315_a((double)par3Icon.func_94212_f(), (double)par3Icon.func_94210_h()).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(par1 + par4), (double)(par2 + 0), 0.0).func_187315_a((double)par3Icon.func_94212_f(), (double)par3Icon.func_94206_g()).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(par1 + 0), (double)(par2 + 0), 0.0).func_187315_a((double)par3Icon.func_94209_e(), (double)par3Icon.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }
}

