/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileAvatar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockAvatar
extends BlockMod
implements ILexiconable {
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.3125, 0.0, 0.21875, 0.6875, 1.0625, 0.78125);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.21875, 0.0, 0.3125, 0.78125, 1.0625, 0.6875);
    private final Random random = new Random();

    protected BlockAvatar() {
        super(Material.field_151575_d, "avatar");
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.NORTH));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((EnumFacing)state.func_177229_b(BotaniaStateProps.CARDINALS)).func_176740_k() == EnumFacing.Axis.X) {
            return X_AABB;
        }
        return Z_AABB;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.CARDINALS});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(BotaniaStateProps.CARDINALS)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        if (meta < 2 || meta > 5) {
            meta = 2;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stackOnPlayer, EnumFacing s, float xs, float ys, float zs) {
        TileAvatar avatar = (TileAvatar)world.func_175625_s(pos);
        ItemStack stackOnAvatar = avatar.getItemHandler().getStackInSlot(0);
        if (stackOnAvatar != null) {
            ItemStack copyStack = stackOnAvatar.func_77946_l();
            avatar.getItemHandler().setStackInSlot(0, null);
            if (!player.field_71071_by.func_70441_a(copyStack)) {
                player.func_71019_a(copyStack, true);
            }
            return true;
        }
        if (stackOnPlayer != null && stackOnPlayer.func_77973_b() instanceof IAvatarWieldable) {
            ItemStack copyStack = stackOnPlayer.func_77946_l();
            avatar.getItemHandler().setStackInSlot(0, copyStack);
            --stackOnPlayer.field_77994_a;
            return true;
        }
        return false;
    }

    public void func_180663_b(World par1World, BlockPos pos, IBlockState state) {
        TileSimpleInventory inv = (TileSimpleInventory)par1World.func_175625_s(pos);
        if (inv != null) {
            for (int j1 = 0; j1 < inv.getSizeInventory(); ++j1) {
                ItemStack itemstack = inv.getItemHandler().getStackInSlot(j1);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int k1 = this.random.nextInt(21) + 10;
                    if (k1 > itemstack.field_77994_a) {
                        k1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= k1;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), new ItemStack(itemstack.func_77973_b(), k1, itemstack.func_77952_i()));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.random.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.random.nextGaussian() * f3;
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    par1World.func_72838_d((Entity)entityitem);
                }
            }
            par1World.func_175666_e(pos, state.func_177230_c());
        }
        super.func_180663_b(par1World, pos, state);
    }

    public void func_180633_a(World p_149689_1_, BlockPos pos, IBlockState state, EntityLivingBase p_149689_5_, ItemStack p_149689_6_) {
        p_149689_1_.func_175656_a(pos, state.func_177226_a(BotaniaStateProps.CARDINALS, (Comparable)p_149689_5_.func_174811_aO().func_176734_d()));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAvatar();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.avatar;
    }
}

