/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.RecipeSorter;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.subtile.ISpecialFlower;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.tile.TileFloatingSpecialFlower;
import vazkii.botania.common.block.tile.TileSpecialFlower;
import vazkii.botania.common.crafting.recipe.SpecialFloatingFlowerRecipe;
import vazkii.botania.common.integration.coloredlights.LightHelper;
import vazkii.botania.common.item.block.ItemBlockFloatingSpecialFlower;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class BlockFloatingSpecialFlower
extends BlockFloatingFlower
implements ISpecialFlower,
IWandable,
ILexiconable,
IWandHUD {
    public BlockFloatingSpecialFlower() {
        super("floatingSpecialFlower");
        GameRegistry.addRecipe((IRecipe)new SpecialFloatingFlowerRecipe());
        RecipeSorter.register((String)"botania:floatingSpecialFlower", SpecialFloatingFlowerRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        this.func_180632_j(((IExtendedBlockState)this.field_176227_L.func_177621_b()).withProperty(BotaniaStateProps.ISLAND_TYPE, (Object)IFloatingFlower.IslandType.GRASS).withProperty(BotaniaStateProps.SUBTILE_ID, (Object)"daybloom").func_177226_a(BotaniaStateProps.COLOR, (Comparable)EnumDyeColor.WHITE));
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BotaniaStateProps.COLOR}, new IUnlistedProperty[]{BotaniaStateProps.SUBTILE_ID, BotaniaStateProps.ISLAND_TYPE});
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.getExtendedState(state, world, pos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileFloatingSpecialFlower) {
            state = ((IExtendedBlockState)state).withProperty(BotaniaStateProps.SUBTILE_ID, (Object)((TileFloatingSpecialFlower)te).subTileName);
        }
        return state;
    }

    @Override
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        int currentLight;
        TileEntity tile = world.func_175625_s(pos);
        int n = currentLight = tile instanceof TileSpecialFlower ? ((TileSpecialFlower)tile).getLightValue() : -1;
        if (currentLight == -1) {
            currentLight = this.originalLight;
        }
        return LightHelper.getPackedColor((EnumDyeColor)world.func_180495_p(pos).func_177229_b(BotaniaStateProps.COLOR), currentLight);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getComparatorInputOverride();
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getPowerLevel(side);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(state, world, pos, side);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Override
    public void func_180655_c(IBlockState state, World par1World, BlockPos pos, Random par5Random) {
    }

    @Override
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        for (String s : BotaniaAPI.subtilesForCreativeMenu) {
            par3List.add(ItemBlockSpecialFlower.ofType(new ItemStack(par1), s));
            if (!BotaniaAPI.miniFlowers.containsKey((Object)s)) continue;
            par3List.add(ItemBlockSpecialFlower.ofType(new ItemStack(par1), (String)BotaniaAPI.miniFlowers.get((Object)s)));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        String name = ((TileSpecialFlower)world.func_175625_s((BlockPos)pos)).subTileName;
        return ItemBlockSpecialFlower.ofType(new ItemStack(state.func_177230_c()), name);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        ((TileSpecialFlower)world.func_175625_s(pos)).onBlockHarvested(world, pos, state, player);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            this.func_176208_a(world, pos, state, player);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            String name = ((TileSpecialFlower)tile).subTileName;
            list.add(ItemBlockSpecialFlower.ofType(new ItemStack(state.func_177230_c()), name));
            ((TileSpecialFlower)tile).getDrops(list);
        }
        return list;
    }

    public boolean func_180648_a(World par1World, BlockPos pos, IBlockState state, int eventID, int value) {
        super.func_180648_a(par1World, pos, state, eventID, value);
        TileEntity tileentity = par1World.func_175625_s(pos);
        return tileentity != null ? tileentity.func_145842_c(eventID, value) : false;
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).onWanded(stack, player);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        ((TileSpecialFlower)world.func_175625_s(pos)).onBlockPlacedBy(world, pos, state, entity, stack);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).onBlockActivated(world, pos, state, player, hand, stack, side, hitX, hitY, hitZ) || super.func_180639_a(world, pos, state, player, hand, stack, side, hitX, hitY, hitZ);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        ((TileSpecialFlower)world.func_175625_s(pos)).onBlockAdded(world, pos, state);
    }

    @Override
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        ((TileSpecialFlower)world.func_175625_s(pos)).renderHUD(mc, res);
    }

    @Override
    public void registerItemForm() {
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockFloatingSpecialFlower(this), (ResourceLocation)this.getRegistryName());
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileFloatingSpecialFlower();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return ((TileSpecialFlower)world.func_175625_s(pos)).getEntry();
    }
}

