/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.api.state.enums.CrateVariant;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileCraftCrate;
import vazkii.botania.common.block.tile.TileOpenCrate;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.item.block.ItemBlockWithMetadataAndName;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockOpenCrate
extends BlockMod
implements ILexiconable,
IWandable,
IWandHUD {
    Random random;

    public BlockOpenCrate() {
        super(Material.field_151575_d, "openCrate");
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.CRATE_VARIANT, (Comparable)((Object)CrateVariant.OPEN)).func_177226_a(BotaniaStateProps.CRATE_PATTERN, (Comparable)((Object)CratePattern.NONE)));
        this.random = new Random();
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.CRATE_VARIANT, BotaniaStateProps.CRATE_PATTERN});
    }

    public int func_176201_c(IBlockState state) {
        return ((CrateVariant)((Object)state.func_177229_b(BotaniaStateProps.CRATE_VARIANT))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= CrateVariant.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.CRATE_VARIANT, (Comparable)((Object)CrateVariant.values()[meta]));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileCraftCrate) {
            TileCraftCrate tile = (TileCraftCrate)world.func_175625_s(pos);
            state = state.func_177226_a(BotaniaStateProps.CRATE_PATTERN, (Comparable)((Object)CratePattern.values()[tile.pattern + 1]));
        } else {
            state = state.func_177226_a(BotaniaStateProps.CRATE_PATTERN, (Comparable)((Object)CratePattern.NONE));
        }
        return state;
    }

    @Override
    public void registerItemForm() {
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockWithMetadataAndName(this), (ResourceLocation)this.getRegistryName());
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        for (int i = 0; i < CrateVariant.values().length; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World par1World, BlockPos pos) {
        TileOpenCrate crate = (TileOpenCrate)par1World.func_175625_s(pos);
        return crate.getSignal();
    }

    public void func_180663_b(World par1World, BlockPos pos, IBlockState state) {
        TileSimpleInventory inv = (TileSimpleInventory)par1World.func_175625_s(pos);
        if (inv != null) {
            for (int j1 = 0; j1 < inv.getSizeInventory(); ++j1) {
                ItemStack itemstack = inv.getItemHandler().getStackInSlot(j1);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int k1 = this.random.nextInt(21) + 10;
                    if (k1 > itemstack.field_77994_a) {
                        k1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= k1;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), new ItemStack(itemstack.func_77973_b(), k1, itemstack.func_77952_i()));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.random.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.random.nextGaussian() * f3;
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    par1World.func_72838_d((Entity)entityitem);
                }
            }
            par1World.func_175666_e(pos, state.func_177230_c());
        }
        super.func_180663_b(par1World, pos, state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return state.func_177229_b(BotaniaStateProps.CRATE_VARIANT) == CrateVariant.OPEN ? new TileOpenCrate() : new TileCraftCrate();
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return world.func_180495_p(pos).func_177229_b(BotaniaStateProps.CRATE_VARIANT) == CrateVariant.OPEN ? LexiconData.openCrate : LexiconData.craftCrate;
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        TileOpenCrate crate = (TileOpenCrate)world.func_175625_s(pos);
        return crate.onWanded(player, stack);
    }

    @Override
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCraftCrate) {
            TileCraftCrate craft = (TileCraftCrate)tile;
            int width = 52;
            int height = 52;
            int xc = res.func_78326_a() / 2 + 20;
            int yc = res.func_78328_b() / 2 - height / 2;
            Gui.func_73734_a((int)(xc - 6), (int)(yc - 6), (int)(xc + width + 6), (int)(yc + height + 6), (int)0x22000000);
            Gui.func_73734_a((int)(xc - 4), (int)(yc - 4), (int)(xc + width + 4), (int)(yc + height + 4), (int)0x22000000);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = i * 3 + j;
                    int xp = xc + j * 18;
                    int yp = yc + i * 18;
                    boolean enabled = true;
                    if (craft.pattern > -1) {
                        enabled = TileCraftCrate.PATTERNS[craft.pattern][index];
                    }
                    Gui.func_73734_a((int)xp, (int)yp, (int)(xp + 16), (int)(yp + 16), (int)(enabled ? 0x22FFFFFF : 0x22FF0000));
                    ItemStack item = craft.getItemHandler().getStackInSlot(index);
                    RenderHelper.func_74520_c();
                    GlStateManager.func_179091_B();
                    mc.func_175599_af().func_180450_b(item, xp, yp);
                    RenderHelper.func_74518_a();
                }
            }
        }
    }
}

