/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockDirtPath
extends BlockMod
implements ILexiconable {
    private static final UUID speedBoostUuid = UUID.fromString("c5f17cca-c89f-4f12-81da-8f04b1f27679");
    private static final AttributeModifier speedBoost = new AttributeModifier(speedBoostUuid, "Trodden dirt speed boost", 0.55, 2).func_111168_a(false);

    public BlockDirtPath() {
        super(Material.field_151578_c, "dirtPath");
        this.func_149713_g(255);
        this.func_149711_c(0.6f);
        this.func_149672_a(SoundType.field_185849_b);
        this.field_149783_u = true;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return type.equals("shovel");
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        EntityLivingBase living;
        IAttributeInstance attr;
        if (!world.field_72995_K && entity instanceof EntityPlayerMP && !(attr = (living = (EntityLivingBase)entity).func_110148_a(SharedMonsterAttributes.field_111263_d)).func_180374_a(speedBoost)) {
            attr.func_111121_a(speedBoost);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState stateAbove = world.func_180495_p(pos.func_177984_a());
        Block blockAbove = stateAbove.func_177230_c();
        if (!blockAbove.isAir(stateAbove, world, pos.func_177984_a())) {
            return field_185505_j;
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        return new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return plantable.getPlantType(world, pos.func_177977_b()) == EnumPlantType.Plains;
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.dirtPath;
    }

    @SubscribeEvent
    public void onTickEnd(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K || event.phase != TickEvent.Phase.END) {
            return;
        }
        for (EntityPlayerMP player : event.world.func_175661_b(EntityPlayerMP.class, p -> p.func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(speedBoost))) {
            if (event.world.func_180495_p(new BlockPos((Entity)player).func_177977_b()).func_177230_c() == this) continue;
            player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(speedBoost);
        }
    }
}

