/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemRedstone;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.item.IFlowerPlaceable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.ISubTileContainer;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.MethodHandles;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;
import vazkii.botania.common.lexicon.LexiconData;
import vazkii.botania.common.lib.LibObfuscation;

public class SubTileRannuncarpus
extends SubTileFunctional {
    private static final int RANGE = 2;
    private static final int RANGE_Y = 3;
    private static final int RANGE_PLACE_MANA = 8;
    private static final int RANGE_PLACE = 6;
    private static final int RANGE_PLACE_Y = 6;
    private static final int RANGE_PLACE_MANA_MINI = 3;
    private static final int RANGE_PLACE_MINI = 2;
    private static final int RANGE_PLACE_Y_MINI = 2;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.redstoneSignal > 0) {
            return;
        }
        if (this.ticksExisted % 10 == 0) {
            BlockData filter = this.getUnderlyingBlock();
            boolean scanned = false;
            ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
            int rangePlace = this.getRange();
            int rangePlaceY = this.getRangeY();
            BlockPos pos = this.supertile.func_174877_v();
            List items = this.supertile.func_145831_w().func_72872_a(EntityItem.class, new AxisAlignedBB(this.supertile.func_174877_v().func_177982_a(-2, -3, -2), this.supertile.func_174877_v().func_177982_a(3, 4, 3)));
            int slowdown = this.getSlowdownFactor();
            for (EntityItem item : items) {
                ItemStack stack;
                Item stackItem;
                int age;
                try {
                    age = MethodHandles.itemAge_getter.invokeExact(item);
                }
                catch (Throwable t) {
                    continue;
                }
                if (age < 60 + slowdown || item.field_70128_L || !((stackItem = (stack = item.func_92059_d()).func_77973_b()) instanceof ItemBlock) && !(stackItem instanceof ItemBlockSpecial) && !(stackItem instanceof ItemRedstone) && !(stackItem instanceof IFlowerPlaceable)) continue;
                if (!scanned) {
                    for (int i = -rangePlace; i < rangePlace + 1; ++i) {
                        for (int j = -rangePlaceY; j < rangePlaceY + 1; ++j) {
                            for (int l = -rangePlace; l < rangePlace + 1; ++l) {
                                BlockPos pos_ = pos.func_177982_a(i, j, l);
                                IBlockState stateAbove = this.supertile.func_145831_w().func_180495_p(pos_.func_177984_a());
                                Block blockAbove = stateAbove.func_177230_c();
                                if (!filter.equals(this.supertile.func_145831_w(), pos_) || !blockAbove.isAir(stateAbove, (IBlockAccess)this.supertile.func_145831_w(), pos_.func_177984_a()) && !blockAbove.func_176200_f((IBlockAccess)this.supertile.func_145831_w(), pos_.func_177984_a())) continue;
                                validPositions.add(pos_.func_177984_a());
                            }
                        }
                    }
                    scanned = true;
                }
                if (validPositions.isEmpty() || this.supertile.func_145831_w().field_72995_K) continue;
                BlockPos coords = (BlockPos)validPositions.get(this.supertile.func_145831_w().field_73012_v.nextInt(validPositions.size()));
                Block blockToPlace = null;
                if (stackItem instanceof IFlowerPlaceable) {
                    blockToPlace = ((IFlowerPlaceable)stackItem).getBlockToPlaceByFlower(stack, this, coords);
                }
                if (stackItem instanceof ItemBlock) {
                    blockToPlace = ((ItemBlock)stackItem).field_150939_a;
                } else if (stackItem instanceof ItemBlockSpecial) {
                    blockToPlace = (Block)ReflectionHelper.getPrivateValue(ItemBlockSpecial.class, (Object)((ItemBlockSpecial)stackItem), (String[])LibObfuscation.REED_ITEM);
                } else if (stackItem instanceof ItemRedstone) {
                    blockToPlace = Blocks.field_150488_af;
                }
                if (blockToPlace == null || !blockToPlace.func_176196_c(this.supertile.func_145831_w(), coords)) continue;
                this.supertile.func_145831_w().func_180501_a(coords, blockToPlace.func_176203_a(stack.func_77952_i()), 3);
                if (ConfigHandler.blockBreakParticles) {
                    this.supertile.func_145831_w().func_175718_b(2001, coords, Block.func_176210_f((IBlockState)blockToPlace.func_176203_a(stack.func_77952_i())));
                }
                validPositions.remove(coords);
                TileEntity tile = this.supertile.func_145831_w().func_175625_s(coords);
                if (tile != null && tile instanceof ISubTileContainer) {
                    ISubTileContainer container = (ISubTileContainer)tile;
                    String subtileName = ItemBlockSpecialFlower.getType(stack);
                    container.setSubTile(subtileName);
                    SubTileEntity subtile = container.getSubTile();
                    subtile.onBlockPlacedBy(this.supertile.func_145831_w(), coords, this.supertile.func_145831_w().func_180495_p(coords), null, stack);
                }
                if (stackItem instanceof IFlowerPlaceable) {
                    ((IFlowerPlaceable)stackItem).onBlockPlacedByFlower(stack, this, coords);
                }
                if (!this.supertile.func_145831_w().field_72995_K) {
                    --stack.field_77994_a;
                    if (stack.field_77994_a == 0) {
                        item.func_70106_y();
                    }
                }
                if (this.mana > 1) {
                    --this.mana;
                }
                return;
            }
        }
    }

    public BlockData getUnderlyingBlock() {
        return new BlockData(this.supertile.func_145831_w(), this.supertile.func_174877_v().func_177979_c(this.supertile instanceof IFloatingFlower ? 1 : 2));
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public void renderHUD(Minecraft mc, ScaledResolution res) {
        super.renderHUD(mc, res);
        BlockData filter = this.getUnderlyingBlock();
        ItemStack recieverStack = new ItemStack(Item.func_150898_a((Block)filter.state.func_177230_c()), 1, filter.state.func_177230_c().func_176201_c(filter.state));
        int color = this.getColor();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (recieverStack != null && recieverStack.func_77973_b() != null) {
            String stackName = recieverStack.func_82833_r();
            int width = 16 + mc.field_71466_p.func_78256_a(stackName) / 2;
            int x = res.func_78326_a() / 2 - width;
            int y = res.func_78328_b() / 2 + 30;
            mc.field_71466_p.func_175063_a(stackName, (float)(x + 20), (float)(y + 5), color);
            RenderHelper.func_74520_c();
            mc.func_175599_af().func_180450_b(recieverStack, x, y);
            RenderHelper.func_74518_a();
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), this.getRange());
    }

    public int getRange() {
        return this.mana > 0 ? 8 : 6;
    }

    public int getRangeY() {
        return 6;
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    @Override
    public int getColor() {
        return 16757375;
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.rannuncarpus;
    }

    static class BlockData {
        final IBlockState state;

        public BlockData(World world, BlockPos pos) {
            this.state = world.func_180495_p(pos);
        }

        public boolean equals(BlockData data) {
            return this.state == data.state;
        }

        public boolean equals(World world, BlockPos pos) {
            return this.equals(new BlockData(world, pos));
        }
    }

    public static class Mini
    extends SubTileRannuncarpus {
        @Override
        public int getRange() {
            return this.mana > 0 ? 3 : 2;
        }

        @Override
        public int getRangeY() {
            return 2;
        }
    }
}

