/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.List;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileNarslimmus
extends SubTileGenerating {
    public static final String TAG_WORLD_SPAWNED = "Botania:WorldSpawned";
    private static final int RANGE = 2;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.ticksExisted % 5 == 0) {
            List slimes = this.supertile.func_145831_w().func_72872_a(EntitySlime.class, new AxisAlignedBB(this.supertile.func_174877_v().func_177982_a(-2, -2, -2), this.supertile.func_174877_v().func_177982_a(3, 3, 3)));
            for (EntitySlime slime : slimes) {
                if (!slime.getEntityData().func_74767_n(TAG_WORLD_SPAWNED) || slime.field_70128_L) continue;
                int size = slime.func_70809_q();
                int mul = (int)Math.pow(2.0, size);
                int mana = 820 * mul;
                if (!slime.field_70170_p.field_72995_K) {
                    slime.func_70106_y();
                    slime.func_184185_a(size > 1 ? SoundEvents.field_187886_fs : SoundEvents.field_187900_fz, 1.0f, 0.02f);
                    this.mana = Math.min(this.getMaxMana(), this.mana + mana);
                    this.sync();
                }
                for (int j = 0; j < mul * 8; ++j) {
                    float f = slime.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                    float f1 = slime.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.5f;
                    float f2 = MathHelper.func_76126_a((float)f) * (float)size * 0.5f * f1;
                    float f3 = MathHelper.func_76134_b((float)f) * (float)size * 0.5f * f1;
                    float f4 = slime.field_70170_p.field_73012_v.nextFloat() * (float)size * 0.5f * f1;
                    slime.field_70170_p.func_175688_a(EnumParticleTypes.SLIME, slime.field_70165_t + (double)f2, slime.func_174813_aQ().field_72338_b + (double)f4, slime.field_70161_v + (double)f3, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 2);
    }

    @Override
    public int getMaxMana() {
        return 8000;
    }

    @Override
    public int getColor() {
        return 7455603;
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.narslimmus;
    }

    public static class SpawnIntercepter {
        @SubscribeEvent
        public void onSpawn(LivingSpawnEvent.CheckSpawn event) {
            if (event.getEntityLiving() instanceof EntitySlime && event.getResult() != Event.Result.DENY && SpawnIntercepter.isSlimeChunk(event.getEntityLiving().field_70170_p, MathHelper.func_76128_c((double)event.getX()), MathHelper.func_76128_c((double)event.getZ()))) {
                event.getEntityLiving().getEntityData().func_74757_a(SubTileNarslimmus.TAG_WORLD_SPAWNED, true);
            }
        }

        public static boolean isSlimeChunk(World world, int x, int z) {
            Chunk chunk = world.func_175726_f(new BlockPos(x, 0, z));
            return chunk.func_76617_a(987234911L).nextInt(10) == 0;
        }
    }
}

