/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.common.block.tile.TileSimpleInventory;

public class TileAvatar
extends TileSimpleInventory
implements IAvatarTile {
    private static final int MAX_MANA = 6400;
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_TICKS_ELAPSED = "ticksElapsed";
    private static final String TAG_MANA = "ticksElapsed";
    boolean enabled;
    int ticksElapsed;
    int mana;

    @Override
    public void updateEntity() {
        ItemStack stack;
        this.enabled = true;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int redstoneSide = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir);
            if (redstoneSide <= 0) continue;
            this.enabled = false;
            break;
        }
        if ((stack = this.itemHandler.getStackInSlot(0)) != null && stack.func_77973_b() instanceof IAvatarWieldable) {
            IAvatarWieldable wieldable = (IAvatarWieldable)stack.func_77973_b();
            wieldable.onAvatarUpdate(this, stack);
        }
        if (this.enabled) {
            ++this.ticksElapsed;
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound par1nbtTagCompound) {
        super.writeCustomNBT(par1nbtTagCompound);
        par1nbtTagCompound.func_74757_a(TAG_ENABLED, this.enabled);
        par1nbtTagCompound.func_74768_a("ticksElapsed", this.ticksElapsed);
        par1nbtTagCompound.func_74768_a("ticksElapsed", this.mana);
    }

    @Override
    public void readCustomNBT(NBTTagCompound par1nbtTagCompound) {
        super.readCustomNBT(par1nbtTagCompound);
        this.enabled = par1nbtTagCompound.func_74767_n(TAG_ENABLED);
        this.ticksElapsed = par1nbtTagCompound.func_74762_e("ticksElapsed");
        this.mana = par1nbtTagCompound.func_74762_e("ticksElapsed");
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new TileSimpleInventory.SimpleItemStackHandler(this, false){

            protected int getStackLimit(int slot, ItemStack stack) {
                return 1;
            }
        };
    }

    @Override
    public boolean isFull() {
        return this.mana >= 6400;
    }

    @Override
    public void recieveMana(int mana) {
        this.mana = Math.min(6400, this.mana + mana);
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return this.itemHandler.getStackInSlot(0) != null;
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public IItemHandler getInventory() {
        return this.getItemHandler();
    }

    @Override
    public int getElapsedFunctionalTicks() {
        return this.ticksElapsed;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

