/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import vazkii.botania.common.block.tile.TileMod;

public class TileCell
extends TileMod {
    private static final String TAG_GENERATION = "generation";
    private static final String TAG_TICKED = "ticked";
    private static final String TAG_FLOWER_X = "flowerX";
    private static final String TAG_FLOWER_Y = "flowerY";
    private static final String TAG_FLOWER_Z = "flowerZ";
    private static final String TAG_VALID_X = "validX";
    private static final String TAG_VALID_Y = "validY";
    private static final String TAG_VALID_Z = "validZ";
    private int generation;
    private boolean ticked;
    private BlockPos flowerCoords = new BlockPos(0, -1, 0);
    private BlockPos validCoords = new BlockPos(0, -1, 0);

    public void setGeneration(TileEntity flower, int gen) {
        this.generation = gen;
        if (!this.ticked) {
            this.flowerCoords = flower.func_174877_v();
            this.validCoords = this.func_174877_v();
            this.ticked = true;
        } else if (!this.matchCoords(this.validCoords, this) || !this.matchCoords(this.flowerCoords, flower)) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    public boolean isSameFlower(TileEntity flower) {
        return this.matchCoords(this.validCoords, this) && this.matchCoords(this.flowerCoords, flower);
    }

    private boolean matchCoords(BlockPos coords, TileEntity tile) {
        return coords.equals((Object)tile.func_174877_v());
    }

    public int getGeneration() {
        return this.generation;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_GENERATION, this.generation);
        cmp.func_74757_a(TAG_TICKED, this.ticked);
        if (this.ticked) {
            cmp.func_74768_a(TAG_FLOWER_X, this.flowerCoords.func_177958_n());
            cmp.func_74768_a(TAG_FLOWER_Y, this.flowerCoords.func_177956_o());
            cmp.func_74768_a(TAG_FLOWER_Z, this.flowerCoords.func_177952_p());
            cmp.func_74768_a(TAG_VALID_X, this.validCoords.func_177958_n());
            cmp.func_74768_a(TAG_VALID_Y, this.validCoords.func_177956_o());
            cmp.func_74768_a(TAG_VALID_Z, this.validCoords.func_177952_p());
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        this.generation = cmp.func_74762_e(TAG_GENERATION);
        this.ticked = cmp.func_74767_n(TAG_TICKED);
        if (this.ticked) {
            this.flowerCoords = new BlockPos(cmp.func_74762_e(TAG_FLOWER_X), cmp.func_74762_e(TAG_FLOWER_Y), cmp.func_74762_e(TAG_FLOWER_Z));
            this.validCoords = new BlockPos(cmp.func_74762_e(TAG_VALID_X), cmp.func_74762_e(TAG_VALID_Y), cmp.func_74762_e(TAG_VALID_Z));
        }
    }
}

