/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.api.wand.IWandBindable;
import vazkii.botania.common.Botania;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;

public class TileLightRelay
extends TileMod
implements IWandBindable {
    private static final int MAX_DIST = 20;
    private static final String TAG_BIND_X = "bindX";
    private static final String TAG_BIND_Y = "bindY";
    private static final String TAG_BIND_Z = "bindZ";
    BlockPos bindPos = new BlockPos(0, -1, 0);
    int ticksElapsed = 0;

    public void mountEntity(Entity e) {
        if (e.func_184218_aH() || this.field_145850_b.field_72995_K || this.bindPos.func_177956_o() == -1 || !this.isValidBinding()) {
            return;
        }
        EntityPlayerMover mover = new EntityPlayerMover(this.field_145850_b, this.field_174879_c, this.bindPos);
        this.field_145850_b.func_72838_d((Entity)mover);
        e.func_184220_m((Entity)mover);
        if (!(e instanceof EntityItem)) {
            mover.func_184185_a(BotaniaSoundEvents.lightRelay, 0.2f, (float)Math.random() * 0.3f + 0.7f);
            if (e instanceof EntityPlayer) {
                ((EntityPlayer)e).func_71064_a((StatBase)ModAchievements.luminizerRide, 1);
            }
        }
    }

    @Override
    public void updateEntity() {
        ++this.ticksElapsed;
        if (this.bindPos.func_177956_o() > -1 && this.isValidBinding()) {
            Vector3 vec = this.getMovementVector();
            double dist = 0.1;
            int size = (int)(vec.mag() / dist);
            int count = 10;
            int start = this.ticksElapsed % size;
            Vector3 vecMag = vec.copy().normalize().multiply(dist);
            Vector3 vecTip = vecMag.copy().multiply(start).add((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
            double radPer = 0.19634954084936207;
            float mul = 0.5f;
            float mulPer = 0.4f;
            float maxMul = 2.0f;
            for (int i = start; i < start + count; ++i) {
                mul = Math.min(maxMul, mul + mulPer);
                double rad = radPer * ((double)i + (double)this.ticksElapsed * 0.4);
                Vector3 vecRot = vecMag.copy().crossProduct(Vector3.one).multiply(mul).rotate(rad, vecMag).add(vecTip);
                Botania.proxy.wispFX(this.field_145850_b, vecRot.x, vecRot.y, vecRot.z, 0.4f, 0.4f, 1.0f, 0.1f, (float)(-vecMag.x), (float)(-vecMag.y), (float)(-vecMag.z), 1.0f);
                vecTip.add(vecMag);
            }
            BlockPos endpoint = this.getEndpoint();
            if (endpoint != null && !this.field_145850_b.field_72995_K) {
                float range = 0.5f;
                List enderPearls = this.field_145850_b.func_72872_a(EntityEnderPearl.class, new AxisAlignedBB(this.field_174879_c.func_177963_a((double)(-range), (double)(-range), (double)(-range)), this.field_174879_c.func_177963_a((double)(1.0f + range), (double)(1.0f + range), (double)(1.0f + range))));
                for (EntityEnderPearl pearl : enderPearls) {
                    pearl.field_70165_t = (double)endpoint.func_177958_n() + pearl.field_70165_t - (double)this.field_174879_c.func_177958_n();
                    pearl.field_70163_u = (double)endpoint.func_177956_o() + pearl.field_70163_u - (double)this.field_174879_c.func_177956_o();
                    pearl.field_70161_v = (double)endpoint.func_177952_p() + pearl.field_70161_v - (double)this.field_174879_c.func_177952_p();
                }
            }
        }
    }

    public boolean isValidBinding() {
        Block block = this.field_145850_b.func_180495_p(this.bindPos).func_177230_c();
        return block == ModBlocks.lightRelay;
    }

    public BlockPos getEndpoint() {
        ArrayList<TileLightRelay> pointsPassed = new ArrayList<TileLightRelay>();
        TileLightRelay relay = this;
        BlockPos lastCoords = null;
        boolean run = true;
        while (run) {
            if (pointsPassed.contains(relay)) {
                return null;
            }
            pointsPassed.add(relay);
            BlockPos coords = relay.getBinding();
            if (coords == null) {
                return lastCoords;
            }
            TileEntity tile = this.field_145850_b.func_175625_s(coords);
            if (tile == null || !(tile instanceof TileLightRelay)) {
                return lastCoords;
            }
            relay = (TileLightRelay)tile;
            lastCoords = coords;
        }
        return null;
    }

    public Vector3 getMovementVector() {
        return new Vector3(this.bindPos.func_177958_n() - this.field_174879_c.func_177958_n(), this.bindPos.func_177956_o() - this.field_174879_c.func_177956_o(), this.bindPos.func_177952_p() - this.field_174879_c.func_177952_p());
    }

    @Override
    public BlockPos getBinding() {
        return this.bindPos.func_177956_o() == -1 ? null : this.bindPos;
    }

    @Override
    public boolean canSelect(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean bindTo(EntityPlayer player, ItemStack wand, BlockPos pos, EnumFacing side) {
        if (player.field_70170_p.func_180495_p(pos).func_177230_c() != ModBlocks.lightRelay || MathHelper.pointDistanceSpace(pos, this.func_174877_v()) > 20.0f) {
            return false;
        }
        this.bindPos = pos;
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        this.bindPos = new BlockPos(cmp.func_74762_e(TAG_BIND_X), cmp.func_74762_e(TAG_BIND_Y), cmp.func_74762_e(TAG_BIND_Z));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_BIND_X, this.bindPos.func_177958_n());
        cmp.func_74768_a(TAG_BIND_Y, this.bindPos.func_177956_o());
        cmp.func_74768_a(TAG_BIND_Z, this.bindPos.func_177952_p());
    }

    public static class EntityPlayerMover
    extends Entity {
        private static final String TAG_EXIT_X = "exitX";
        private static final String TAG_EXIT_Y = "exitY";
        private static final String TAG_EXIT_Z = "exitZ";
        private static final DataParameter<BlockPos> EXIT_POS = EntityDataManager.func_187226_a(EntityPlayerMover.class, (DataSerializer)DataSerializers.field_187200_j);

        public EntityPlayerMover(World world) {
            super(world);
        }

        public EntityPlayerMover(World world, BlockPos pos, BlockPos exitPos) {
            this(world);
            this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            this.setExit(exitPos);
        }

        protected void func_70088_a() {
            this.func_70105_a(0.0f, 0.0f);
            this.field_70145_X = true;
            this.field_70180_af.func_187214_a(EXIT_POS, (Object)BlockPos.field_177992_a);
        }

        public void func_70071_h_() {
            BlockPos exitPos;
            BlockPos pos;
            super.func_70071_h_();
            if (this.func_184188_bt().isEmpty() && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                return;
            }
            boolean isItem = this.func_184187_bx() instanceof EntityItem;
            if (!isItem && this.field_70173_aa % 30 == 0) {
                this.func_184185_a(BotaniaSoundEvents.lightRelay, 0.05f, (float)Math.random() * 0.3f + 0.7f);
            }
            if ((pos = new BlockPos((Entity)this)).equals((Object)(exitPos = this.getExitPos()))) {
                TileEntity tile = this.field_70170_p.func_175625_s(pos);
                if (tile != null && tile instanceof TileLightRelay) {
                    TileLightRelay relay;
                    BlockPos bind;
                    if (this.field_70170_p.func_180495_p(pos).func_177229_b(BotaniaStateProps.LUMINIZER_VARIANT) == LuminizerVariant.DETECTOR) {
                        this.field_70170_p.func_180501_a(pos, this.field_70170_p.func_180495_p(pos).func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(true)), 3);
                        this.field_70170_p.func_175684_a(pos, tile.func_145838_q(), tile.func_145838_q().func_149738_a(this.field_70170_p));
                    }
                    if ((bind = (relay = (TileLightRelay)tile).getBinding()) != null && relay.isValidBinding()) {
                        this.setExit(bind);
                        return;
                    }
                }
                this.field_70163_u += 1.5;
                this.func_70106_y();
            } else {
                Vector3 thisVec = Vector3.fromEntity(this);
                Vector3 motVec = thisVec.negate().add((double)exitPos.func_177958_n() + 0.5, (double)exitPos.func_177956_o() + 0.5, (double)exitPos.func_177952_p() + 0.5).normalize().multiply(0.5);
                int count = 4;
                for (int i = 0; i < count; ++i) {
                    Color color = Color.getHSBColor((float)this.field_70173_aa / 36.0f + 1.0f / (float)count * (float)i, 1.0f, 1.0f);
                    double rad = Math.PI * 2 / (double)count * (double)i + (double)this.field_70173_aa / Math.PI;
                    double cos = Math.cos(rad);
                    double sin = Math.sin(rad);
                    double s = 0.4;
                    Botania.proxy.sparkleFX(this.field_70170_p, this.field_70165_t + cos * s, this.field_70163_u - 0.5, this.field_70161_v + sin * s, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.2f, 10);
                }
                this.field_70165_t += motVec.x;
                this.field_70163_u += motVec.y;
                this.field_70161_v += motVec.z;
            }
        }

        public boolean shouldRiderSit() {
            return false;
        }

        public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
            return false;
        }

        protected void func_70037_a(NBTTagCompound cmp) {
            this.setExit(new BlockPos(cmp.func_74762_e(TAG_EXIT_X), cmp.func_74762_e(TAG_EXIT_Y), cmp.func_74762_e(TAG_EXIT_Z)));
        }

        protected void func_70014_b(NBTTagCompound cmp) {
            BlockPos exit = this.getExitPos();
            cmp.func_74768_a(TAG_EXIT_X, exit.func_177958_n());
            cmp.func_74768_a(TAG_EXIT_Y, exit.func_177956_o());
            cmp.func_74768_a(TAG_EXIT_Z, exit.func_177952_p());
        }

        public BlockPos getExitPos() {
            return (BlockPos)this.field_70180_af.func_187225_a(EXIT_POS);
        }

        public void setExit(BlockPos pos) {
            this.field_70180_af.func_187227_b(EXIT_POS, (Object)pos);
        }
    }
}

