/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.core.handler.MethodHandles;

public class TileSpawnerClaw
extends TileMod
implements IManaReceiver {
    private static final String TAG_MANA = "mana";
    int mana = 0;

    @Override
    public void updateEntity() {
        TileEntity tileBelow = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (this.mana >= 5 && tileBelow instanceof TileEntityMobSpawner) {
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)tileBelow;
            MobSpawnerBaseLogic logic = spawner.func_145881_a();
            try {
                if (!MethodHandles.isActivated.invokeExact(logic)) {
                    if (!this.field_145850_b.field_72995_K) {
                        this.mana -= 6;
                    }
                    if (logic.func_98271_a().field_72995_K) {
                        int delay = MethodHandles.spawnDelay_getter.invokeExact(logic);
                        if (delay > 0) {
                            MethodHandles.spawnDelay_setter.invokeExact(logic, delay - 1);
                        }
                        if (Math.random() > 0.5) {
                            Botania.proxy.wispFX(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.3 + Math.random() * 0.5, (double)this.func_174877_v().func_177956_o() - 0.3 + Math.random() * 0.25, (double)this.func_174877_v().func_177952_p() + Math.random(), 0.6f - (float)Math.random() * 0.3f, 0.1f, 0.6f - (float)Math.random() * 0.3f, (float)Math.random() / 3.0f, -0.025f - 0.005f * (float)Math.random(), 2.0f);
                        }
                        MethodHandles.prevMobRotation_setter.invokeExact(logic, logic.func_177222_d());
                        MethodHandles.mobRotation_setter.invokeExact(logic, (logic.func_177222_d() + (double)(1000.0f / ((float)MethodHandles.spawnDelay_getter.invokeExact(logic) + 200.0f))) % 360.0);
                    } else {
                        int delay;
                        if (MethodHandles.spawnDelay_getter.invokeExact(logic) == -1) {
                            this.resetTimer(logic);
                        }
                        if ((delay = MethodHandles.spawnDelay_getter.invokeExact(logic)) > 0) {
                            MethodHandles.spawnDelay_setter.invokeExact(logic, delay - 1);
                            return;
                        }
                        if (logic.func_98271_a().field_72995_K) {
                            return;
                        }
                        boolean flag = false;
                        int spawnCount = MethodHandles.spawnCount_getter.invokeExact(logic);
                        int spawnRange = MethodHandles.spawnRange_getter.invokeExact(logic);
                        int maxNearbyEntities = MethodHandles.maxNearbyEntities_getter.invokeExact(logic);
                        WeightedSpawnerEntity randomEntity = MethodHandles.randomEntity_getter.invokeExact(logic);
                        BlockPos blockpos = logic.func_177221_b();
                        for (int i = 0; i < spawnCount; ++i) {
                            double d2;
                            double d1;
                            int j;
                            double d0;
                            NBTTagCompound nbttagcompound = randomEntity.func_185277_b();
                            NBTTagList nbttaglist = nbttagcompound.func_150295_c("Pos", 6);
                            World world = logic.func_98271_a();
                            Entity entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)nbttagcompound, (World)world, (double)(d0 = (j = nbttaglist.func_74745_c()) >= 1 ? nbttaglist.func_150309_d(0) : (double)blockpos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)spawnRange + 0.5), (double)(d1 = j >= 2 ? nbttaglist.func_150309_d(1) : (double)(blockpos.func_177956_o() + world.field_73012_v.nextInt(3) - 1)), (double)(d2 = j >= 3 ? nbttaglist.func_150309_d(2) : (double)blockpos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)spawnRange + 0.5), (boolean)false);
                            if (entity == null) {
                                return;
                            }
                            int k = world.func_72872_a(entity.getClass(), new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g((double)spawnRange)).size();
                            if (k >= maxNearbyEntities) {
                                this.resetTimer(logic);
                                return;
                            }
                            EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                            entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                            if (entityliving != null && !entityliving.func_70601_bi()) continue;
                            if (randomEntity.func_185277_b().func_186856_d() == 1 && randomEntity.func_185277_b().func_150297_b("id", 8) && entity instanceof EntityLiving) {
                                ((EntityLiving)entity).func_180482_a(world.func_175649_E(new BlockPos(entity)), null);
                            }
                            AnvilChunkLoader.func_186052_a((Entity)entity, (World)world);
                            world.func_175718_b(2004, blockpos, 0);
                            if (entityliving != null) {
                                entityliving.func_70656_aK();
                            }
                            flag = true;
                        }
                        if (flag) {
                            this.resetTimer(logic);
                        }
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void resetTimer(MobSpawnerBaseLogic logic) throws Throwable {
        int maxSpawnDelay = MethodHandles.maxSpawnDelay_getter.invokeExact(logic);
        int minSpawnDelay = MethodHandles.minSpawnDelay_getter.invokeExact(logic);
        List potentialEntitySpawns = MethodHandles.potentialSpawns_getter.invokeExact(logic);
        if (maxSpawnDelay <= minSpawnDelay) {
            MethodHandles.spawnDelay_setter.invokeExact(logic, minSpawnDelay);
        } else {
            int i = maxSpawnDelay - minSpawnDelay;
            MethodHandles.spawnDelay_setter.invokeExact(logic, minSpawnDelay + logic.func_98271_a().field_73012_v.nextInt(i));
        }
        if (potentialEntitySpawns != null && potentialEntitySpawns.size() > 0) {
            logic.func_184993_a((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)logic.func_98271_a().field_73012_v, (List)potentialEntitySpawns));
        }
        logic.func_98267_a(1);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
    }

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= 160;
    }

    @Override
    public void recieveMana(int mana) {
        this.mana = Math.min(160, this.mana + mana);
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return true;
    }
}

