/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import net.minecraft.block.BlockFurnace;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.subtile.functional.SubTileExoflame;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.mana.TilePool;

public class TileBellows
extends TileMod {
    private static final String TAG_ACTIVE = "active";
    public float movePos;
    public boolean active = false;
    public float moving = 0.0f;

    public void interact() {
        if (this.moving == 0.0f) {
            this.setActive(true);
        }
    }

    @Override
    public void updateEntity() {
        boolean disable = true;
        TileEntity tile = this.getLinkedTile();
        if (!this.active && tile instanceof TilePool) {
            TilePool pool = (TilePool)tile;
            boolean transfer = pool.isDoingTransfer;
            if (transfer) {
                if (!this.active && pool.ticksDoingTransfer >= this.func_145832_p() * 2 - 2) {
                    this.setActive(true);
                }
                disable = false;
            }
        }
        float max = 0.9f;
        float min = 0.0f;
        float incr = max / 20.0f;
        if (this.movePos < max && this.active && this.moving >= 0.0f) {
            if (this.moving == 0.0f) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, BotaniaSoundEvents.bellows, SoundCategory.BLOCKS, 0.1f, 3.0f);
            }
            if (tile instanceof TileEntityFurnace) {
                TileEntityFurnace furnace = (TileEntityFurnace)tile;
                if (SubTileExoflame.canFurnaceSmelt(furnace)) {
                    furnace.func_174885_b(2, Math.min(199, furnace.func_174887_a_(2) + 20));
                    furnace.func_174885_b(0, Math.max(0, furnace.func_174887_a_(0) - 10));
                }
                if (furnace.func_145830_o() && furnace.func_145838_q() == Blocks.field_150470_am) {
                    EnumFacing enumfacing = (EnumFacing)this.field_145850_b.func_180495_p(furnace.func_174877_v()).func_177229_b((IProperty)BlockFurnace.field_176447_a);
                    double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
                    double d1 = (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble() * 6.0 / 16.0;
                    double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
                    double d3 = 0.52;
                    double d4 = this.field_145850_b.field_73012_v.nextDouble() * 0.6 - 0.3;
                    switch (enumfacing) {
                        case WEST: {
                            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                            this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                            break;
                        }
                        case EAST: {
                            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                            this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                            break;
                        }
                        case NORTH: {
                            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                            this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                            break;
                        }
                        case SOUTH: {
                            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                            this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                }
            }
            this.movePos += incr * 3.0f;
            this.moving = incr * 3.0f;
            if (this.movePos >= max) {
                this.movePos = Math.min(max, this.movePos);
                this.moving = 0.0f;
                if (disable) {
                    this.setActive(false);
                }
            }
        } else if (this.movePos > min) {
            this.movePos -= incr;
            this.moving = -incr;
            if (this.movePos <= min) {
                this.movePos = Math.max(min, this.movePos);
                this.moving = 0.0f;
            }
        }
    }

    public TileEntity getLinkedTile() {
        EnumFacing side = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(BotaniaStateProps.CARDINALS);
        return this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp) {
        cmp.func_74757_a(TAG_ACTIVE, this.active);
    }

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        this.active = cmp.func_74767_n(TAG_ACTIVE);
    }

    public void setActive(boolean active) {
        if (!this.field_145850_b.field_72995_K) {
            boolean diff = this.active != active;
            this.active = active;
            if (diff) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
            }
        }
    }
}

