/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import com.google.common.collect.ImmutableMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.animation.TimeValues;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.TileMod;

public class TilePump
extends TileMod {
    private static final String TAG_ACTIVE = "active";
    public float innerRingPos;
    public boolean active = false;
    public boolean hasCart = false;
    public boolean hasCartOnTop = false;
    public float moving = 0.0f;
    public int comparator;
    public boolean hasRedstone = false;
    private int lastComparator = 0;
    private final TimeValues.VariableValue move;
    private final IAnimationStateMachine asm;

    public TilePump() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.move = new TimeValues.VariableValue(0.0f);
            this.asm = ModelLoaderRegistry.loadASM((ResourceLocation)new ResourceLocation("botania", "asms/block/pump.json"), (ImmutableMap)ImmutableMap.of((Object)"move", (Object)this.move));
        } else {
            this.move = null;
            this.asm = null;
        }
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing side) {
        return cap == CapabilityAnimation.ANIMATION_CAPABILITY || super.hasCapability(cap, side);
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityAnimation.ANIMATION_CAPABILITY) {
            return (T)CapabilityAnimation.ANIMATION_CAPABILITY.cast((Object)this.asm);
        }
        return (T)super.getCapability(cap, side);
    }

    @Override
    public void updateEntity() {
        this.hasRedstone = false;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int redstoneSide = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir);
            if (redstoneSide <= 0) continue;
            this.hasRedstone = true;
            break;
        }
        float max = 8.0f;
        float min = 0.0f;
        float incr = max / 10.0f;
        if (this.innerRingPos < max && this.active && this.moving >= 0.0f) {
            this.innerRingPos += incr;
            this.moving = incr;
            if (this.innerRingPos >= max) {
                this.innerRingPos = Math.min(max, this.innerRingPos);
                this.moving = 0.0f;
                for (int x = 0; x < 2; ++x) {
                    this.field_145850_b.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (double)this.func_174877_v().func_177958_n() + Math.random(), (double)this.func_174877_v().func_177956_o() + Math.random(), (double)this.func_174877_v().func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                }
            }
        } else if (this.innerRingPos > min) {
            this.innerRingPos -= incr * 2.0f;
            this.moving = -incr * 2.0f;
            if (this.innerRingPos <= min) {
                this.innerRingPos = Math.max(min, this.innerRingPos);
                this.moving = 0.0f;
            }
        }
        if (this.field_145850_b.field_72995_K) {
            this.move.setValue(this.innerRingPos / 8.0f * 0.5f);
        }
        if (!this.hasCartOnTop) {
            this.comparator = 0;
        }
        if (!this.hasCart && this.active) {
            this.setActive(false);
        }
        if (this.active && this.hasRedstone) {
            this.setActive(false);
        }
        this.hasCart = false;
        this.hasCartOnTop = false;
        if (this.comparator != this.lastComparator) {
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
        }
        this.lastComparator = this.comparator;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp) {
        cmp.func_74757_a(TAG_ACTIVE, this.active);
    }

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        boolean prevActive = this.active;
        this.active = cmp.func_74767_n(TAG_ACTIVE);
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K || prevActive != this.active) {
            // empty if block
        }
    }

    public void setActive(boolean active) {
        if (!this.field_145850_b.field_72995_K) {
            boolean diff = this.active != active;
            this.active = active;
            if (diff) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
            }
        }
    }
}

