/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.mana.TileSpreader;

public class TileTurntable
extends TileMod {
    private static final String TAG_SPEED = "speed";
    private static final String TAG_BACKWARDS = "backwards";
    int speed = 1;
    boolean backwards = false;

    @Override
    public void updateEntity() {
        TileEntity tile;
        boolean redstone = false;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int redstoneSide = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir);
            if (redstoneSide <= 0) continue;
            redstone = true;
        }
        if (!redstone && (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())) instanceof TileSpreader) {
            TileSpreader spreader = (TileSpreader)tile;
            spreader.rotationX = spreader.rotationX + (float)(this.speed * (this.backwards ? -1 : 1));
            if (spreader.rotationX >= 360.0f) {
                spreader.rotationX -= 360.0f;
            }
            if (!this.field_145850_b.field_72995_K) {
                spreader.checkForReceiver();
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_SPEED, this.speed);
        cmp.func_74757_a(TAG_BACKWARDS, this.backwards);
    }

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        this.speed = cmp.func_74762_e(TAG_SPEED);
        this.backwards = cmp.func_74767_n(TAG_BACKWARDS);
    }

    public void onWanded(EntityPlayer player, ItemStack wand) {
        if (player == null) {
            return;
        }
        if (player.func_70093_af()) {
            this.backwards = !this.backwards;
        } else {
            this.speed = this.speed == 6 ? 1 : this.speed + 1;
        }
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
    }

    public void renderHUD(Minecraft mc, ScaledResolution res) {
        int color = -1442814464;
        char motion = this.backwards ? (char)'<' : '>';
        String speed = TextFormatting.BOLD + "";
        for (int i = 0; i < this.speed; ++i) {
            speed = speed + motion;
        }
        int x = res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(speed) / 2;
        int y = res.func_78328_b() / 2 - 15;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        mc.field_71466_p.func_175063_a(speed, (float)x, (float)y, color);
        GlStateManager.func_179084_k();
    }
}

