/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.string;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.tile.string.TileRedString;

public class TileRedStringInterceptor
extends TileRedString {
    private static final ThreadLocal<Set<TileRedStringInterceptor>> interceptors = ThreadLocal.withInitial(HashSet::new);

    @Override
    public void updateEntity() {
        super.updateEntity();
        interceptors.get().add(this);
    }

    @Override
    public boolean acceptBlock(BlockPos pos) {
        return this.field_145850_b.func_175625_s(pos) != null;
    }

    private boolean saneState() {
        return !this.func_145837_r() && this.field_145850_b.func_175625_s(this.field_174879_c) == this;
    }

    public static void onInteract(EntityPlayer player, World world, BlockPos pos, EnumHand hand) {
        ArrayList<TileRedStringInterceptor> remove = new ArrayList<TileRedStringInterceptor>();
        boolean did = false;
        for (TileRedStringInterceptor inter : interceptors.get()) {
            BlockPos coords;
            if (!inter.saneState()) {
                remove.add(inter);
                continue;
            }
            if (inter.field_145850_b != world || (coords = inter.getBinding()) == null || !coords.equals((Object)pos)) continue;
            if (!world.field_72995_K) {
                Block block = inter.func_145838_q();
                world.func_180501_a(inter.func_174877_v(), world.func_180495_p(inter.func_174877_v()).func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(true)), 3);
                world.func_175684_a(inter.func_174877_v(), block, block.func_149738_a(world));
            }
            did = true;
        }
        interceptors.get().removeAll(remove);
        if (did) {
            if (world.field_72995_K) {
                player.func_184609_a(hand);
            } else {
                world.func_184133_a(null, pos, SoundEvents.field_187574_as, SoundCategory.BLOCKS, 0.3f, 0.6f);
            }
        }
    }
}

