/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.base.Optional;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.ARBShaderObjects;
import vazkii.botania.api.boss.IBotaniaBossWithShader;
import vazkii.botania.api.internal.ShaderCallback;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.lexicon.multiblock.component.MultiblockComponent;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.PylonVariant;
import vazkii.botania.client.core.handler.BossBarHandler;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityMagicLandmine;
import vazkii.botania.common.entity.EntityMagicMissile;
import vazkii.botania.common.entity.EntityPixie;
import vazkii.botania.common.item.ModItems;

public class EntityDoppleganger
extends EntityCreature
implements IBotaniaBossWithShader {
    private static final int SPAWN_TICKS = 160;
    private static final float RANGE = 12.0f;
    private static final float MAX_HP = 800.0f;
    private static final int MOB_SPAWN_START_TICKS = 20;
    private static final int MOB_SPAWN_END_TICKS = 80;
    private static final int MOB_SPAWN_BASE_TICKS = 800;
    private static final int MOB_SPAWN_TICKS = 900;
    private static final int MOB_SPAWN_WAVES = 10;
    private static final int MOB_SPAWN_WAVE_TIME = 80;
    private static final String TAG_INVUL_TIME = "invulTime";
    private static final String TAG_AGGRO = "aggro";
    private static final String TAG_SOURCE_X = "sourceX";
    private static final String TAG_SOURCE_Y = "sourceY";
    private static final String TAG_SOURCE_Z = "sourcesZ";
    private static final String TAG_MOB_SPAWN_TICKS = "mobSpawnTicks";
    private static final String TAG_HARD_MODE = "hardMode";
    private static final String TAG_PLAYER_COUNT = "playerCount";
    private static final DataParameter<Integer> INVUL_TIME = EntityDataManager.func_187226_a(EntityDoppleganger.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_MOB_SPAWN_TICKS = EntityDataManager.func_187226_a(EntityDoppleganger.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PLAYER_COUNT = EntityDataManager.func_187226_a(EntityDoppleganger.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TP_DELAY = EntityDataManager.func_187226_a(EntityDoppleganger.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> AGGRO = EntityDataManager.func_187226_a(EntityDoppleganger.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HARD_MODE = EntityDataManager.func_187226_a(EntityDoppleganger.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<BlockPos> SOURCE = EntityDataManager.func_187226_a(EntityDoppleganger.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Optional<UUID>> BOSSINFO_ID = EntityDataManager.func_187226_a(EntityDoppleganger.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final BlockPos[] PYLON_LOCATIONS = new BlockPos[]{new BlockPos(4, 1, 4), new BlockPos(4, 1, -4), new BlockPos(-4, 1, 4), new BlockPos(-4, 1, -4)};
    private static final List<String> CHEATY_BLOCKS = Arrays.asList("OpenBlocks:beartrap", "ThaumicTinkerer:magnet");
    private boolean spawnLandmines = false;
    private boolean spawnPixies = false;
    private boolean anyWithArmor = false;
    private List<UUID> playersWhoAttacked = new ArrayList<UUID>();
    public EntityPlayer trueKiller = null;
    private static boolean isPlayingMusic = false;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PINK, BossInfo.Overlay.PROGRESS).func_186743_c(true);
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*\\])|(?:ComputerCraft)$");
    @SideOnly(value=Side.CLIENT)
    private static Rectangle barRect;
    @SideOnly(value=Side.CLIENT)
    private static Rectangle hpBarRect;
    @SideOnly(value=Side.CLIENT)
    private ShaderCallback shaderCallback;

    public EntityDoppleganger(World par1World) {
        super(par1World);
        this.func_70105_a(0.6f, 1.8f);
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, Float.MAX_VALUE));
        this.field_70178_ae = true;
        this.field_70728_aV = 825;
        Botania.proxy.addBoss(this);
    }

    public static MultiblockSet makeMultiblockSet() {
        Multiblock mb = new Multiblock();
        for (BlockPos p : PYLON_LOCATIONS) {
            mb.addComponent(p.func_177984_a(), ModBlocks.pylon.func_176223_P().func_177226_a(BotaniaStateProps.PYLON_VARIANT, (Comparable)((Object)PylonVariant.GAIA)));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                mb.addComponent(new BeaconComponent(new BlockPos(i - 1, 0, j - 1)));
            }
        }
        mb.addComponent(new BeaconBeamComponent(new BlockPos(0, 1, 0)));
        mb.setRenderOffset(new BlockPos(0, -1, 0));
        return mb.makeSet();
    }

    public static boolean spawn(EntityPlayer player, ItemStack par1ItemStack, World par3World, BlockPos pos, boolean hard) {
        if (par3World.func_175625_s(pos) instanceof TileEntityBeacon && EntityDoppleganger.isTruePlayer((Entity)player)) {
            if (par3World.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                if (!par3World.field_72995_K) {
                    player.func_145747_a(new TextComponentTranslation("botaniamisc.peacefulNoob", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
                return false;
            }
            for (BlockPos coords : PYLON_LOCATIONS) {
                BlockPos pos_ = pos.func_177971_a((Vec3i)coords);
                IBlockState state = par3World.func_180495_p(pos_);
                Block blockat = state.func_177230_c();
                if (blockat == ModBlocks.pylon && state.func_177229_b(BotaniaStateProps.PYLON_VARIANT) == PylonVariant.GAIA) continue;
                if (!par3World.field_72995_K) {
                    player.func_145747_a(new TextComponentTranslation("botaniamisc.needsCatalysts", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
                return false;
            }
            if (!EntityDoppleganger.hasProperArena(par3World, pos)) {
                for (int i = 0; i < 360; i += 8) {
                    float r = 1.0f;
                    float g = 0.0f;
                    float b = 1.0f;
                    float rad = (float)i * (float)Math.PI / 180.0f;
                    double x = (double)pos.func_177958_n() + 0.5 - Math.cos(rad) * 12.0;
                    double y = (double)pos.func_177956_o() + 0.5;
                    double z = (double)pos.func_177952_p() + 0.5 - Math.sin(rad) * 12.0;
                    Botania.proxy.sparkleFX(par3World, x, y, z, r, g, b, 5.0f, 120);
                }
                if (!par3World.field_72995_K) {
                    player.func_145747_a(new TextComponentTranslation("botaniamisc.badArena", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
                return false;
            }
            --par1ItemStack.field_77994_a;
            if (par3World.field_72995_K) {
                return true;
            }
            EntityDoppleganger e = new EntityDoppleganger(par3World);
            e.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 3, (double)pos.func_177952_p() + 0.5);
            e.setInvulTime(160);
            e.func_70606_j(1.0f);
            e.setSource(pos);
            e.setMobSpawnTicks(900);
            e.setHardMode(hard);
            List<EntityPlayer> players = e.getPlayersAround();
            int playerCount = 0;
            for (EntityPlayer p : players) {
                if (!EntityDoppleganger.isTruePlayer((Entity)p)) continue;
                ++playerCount;
            }
            e.setPlayerCount(playerCount);
            e.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(800.0f * (float)playerCount));
            e.func_184185_a(SoundEvents.field_187525_aO, 10.0f, 0.1f);
            par3World.func_72838_d((Entity)e);
            return true;
        }
        return false;
    }

    private static boolean hasProperArena(World world, BlockPos startPos) {
        int heightCheck = 3;
        int heightMin = 2;
        int range = (int)Math.ceil(12.0);
        for (int i = -range; i < range + 1; ++i) {
            block1: for (int j = -range; j < range + 1; ++j) {
                if (Math.abs(i) == 4 && Math.abs(j) == 4 || MathHelper.pointDistancePlane(i, j, 0.0, 0.0) > 12.0f) continue;
                int air = 0;
                for (int k = heightCheck + heightMin + 1; k >= -heightCheck; --k) {
                    boolean isAir;
                    BlockPos pos = startPos.func_177982_a(i, k, j);
                    boolean bl = isAir = world.func_180495_p(pos).func_185890_d(world, pos) == null;
                    if (isAir) {
                        ++air;
                        continue;
                    }
                    if (k > heightCheck) continue;
                    if (air > 2) continue block1;
                    air = 0;
                }
                return false;
            }
        }
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INVUL_TIME, (Object)0);
        this.field_70180_af.func_187214_a(AGGRO, (Object)false);
        this.field_70180_af.func_187214_a(TP_DELAY, (Object)0);
        this.field_70180_af.func_187214_a(SOURCE, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(DATA_MOB_SPAWN_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(HARD_MODE, (Object)false);
        this.field_70180_af.func_187214_a(PLAYER_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(BOSSINFO_ID, (Object)Optional.absent());
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVUL_TIME);
    }

    public boolean isAggroed() {
        return (Boolean)this.field_70180_af.func_187225_a(AGGRO);
    }

    public int getTPDelay() {
        return (Integer)this.field_70180_af.func_187225_a(TP_DELAY);
    }

    public BlockPos getSource() {
        return (BlockPos)this.field_70180_af.func_187225_a(SOURCE);
    }

    public int getMobSpawnTicks() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_MOB_SPAWN_TICKS);
    }

    public boolean isHardMode() {
        return (Boolean)this.field_70180_af.func_187225_a(HARD_MODE);
    }

    public int getPlayerCount() {
        return (Integer)this.field_70180_af.func_187225_a(PLAYER_COUNT);
    }

    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVUL_TIME, (Object)time);
    }

    public void setAggroed(boolean aggored) {
        this.field_70180_af.func_187227_b(AGGRO, (Object)aggored);
    }

    public void setTPDelay(int delay) {
        this.field_70180_af.func_187227_b(TP_DELAY, (Object)delay);
    }

    public void setSource(BlockPos pos) {
        this.field_70180_af.func_187227_b(SOURCE, (Object)pos);
    }

    public void setMobSpawnTicks(int ticks) {
        this.field_70180_af.func_187227_b(DATA_MOB_SPAWN_TICKS, (Object)ticks);
    }

    public void setHardMode(boolean hardMode) {
        this.field_70180_af.func_187227_b(HARD_MODE, (Object)hardMode);
    }

    public void setPlayerCount(int count) {
        this.field_70180_af.func_187227_b(PLAYER_COUNT, (Object)count);
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a(TAG_INVUL_TIME, this.getInvulTime());
        par1nbtTagCompound.func_74757_a(TAG_AGGRO, this.isAggroed());
        par1nbtTagCompound.func_74768_a(TAG_MOB_SPAWN_TICKS, this.getMobSpawnTicks());
        BlockPos source = this.getSource();
        par1nbtTagCompound.func_74768_a(TAG_SOURCE_X, source.func_177958_n());
        par1nbtTagCompound.func_74768_a(TAG_SOURCE_Y, source.func_177956_o());
        par1nbtTagCompound.func_74768_a(TAG_SOURCE_Z, source.func_177952_p());
        par1nbtTagCompound.func_74757_a(TAG_HARD_MODE, this.isHardMode());
        par1nbtTagCompound.func_74768_a(TAG_PLAYER_COUNT, this.getPlayerCount());
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.setInvulTime(par1nbtTagCompound.func_74762_e(TAG_INVUL_TIME));
        this.setAggroed(par1nbtTagCompound.func_74767_n(TAG_AGGRO));
        this.setMobSpawnTicks(par1nbtTagCompound.func_74762_e(TAG_MOB_SPAWN_TICKS));
        int x = par1nbtTagCompound.func_74762_e(TAG_SOURCE_X);
        int y = par1nbtTagCompound.func_74762_e(TAG_SOURCE_Y);
        int z = par1nbtTagCompound.func_74762_e(TAG_SOURCE_Z);
        this.setSource(new BlockPos(x, y, z));
        this.setHardMode(par1nbtTagCompound.func_74767_n(TAG_HARD_MODE));
        if (par1nbtTagCompound.func_74764_b(TAG_PLAYER_COUNT)) {
            this.setPlayerCount(par1nbtTagCompound.func_74762_e(TAG_PLAYER_COUNT));
        } else {
            this.setPlayerCount(1);
        }
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        Entity e = par1DamageSource.func_76346_g();
        if ((par1DamageSource.field_76373_n.equals("player") || e instanceof EntityPixie) && e != null && EntityDoppleganger.isTruePlayer(e) && this.getInvulTime() == 0) {
            EntityPlayer player = (EntityPlayer)e;
            if (!this.playersWhoAttacked.contains(player.func_110124_au())) {
                this.playersWhoAttacked.add(player.func_110124_au());
            }
            boolean crit = false;
            if (e instanceof EntityPlayer) {
                EntityPlayer p = (EntityPlayer)e;
                crit = p.field_70143_R > 0.0f && !p.field_70122_E && !p.func_70617_f_() && !p.func_70090_H() && !p.func_70644_a(MobEffects.field_76440_q) && !p.func_184218_aH();
            }
            int cap = crit ? 60 : 40;
            return super.func_70097_a(par1DamageSource, Math.min((float)cap, par2) * (this.isHardMode() ? 0.6f : 1.0f));
        }
        return false;
    }

    public static boolean isTruePlayer(Entity e) {
        if (!(e instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)e;
        String name = player.func_70005_c_();
        return !(player instanceof FakePlayer) && !FAKE_PLAYER_PATTERN.matcher(name).matches();
    }

    protected void func_70665_d(DamageSource par1DamageSource, float par2) {
        super.func_70665_d(par1DamageSource, par2);
        Entity attacker = par1DamageSource.func_76346_g();
        if (attacker != null) {
            Vector3 thisVector = Vector3.fromEntityCenter((Entity)this);
            Vector3 playerVector = Vector3.fromEntityCenter(attacker);
            Vector3 motionVector = thisVector.copy().sub(playerVector).copy().normalize().multiply(0.75);
            if (this.func_110143_aJ() > 0.0f) {
                this.field_70159_w = -motionVector.x;
                this.field_70181_x = 0.5;
                this.field_70179_y = -motionVector.z;
                this.setTPDelay(4);
                this.spawnPixies = this.isAggroed();
            }
            this.setAggroed(true);
        }
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
        EntityLivingBase entitylivingbase = this.func_94060_bK();
        if (entitylivingbase instanceof EntityPlayer) {
            ((EntityPlayer)entitylivingbase).func_71064_a((StatBase)ModAchievements.gaiaGuardianKill, 1);
            if (!this.anyWithArmor) {
                ((EntityPlayer)entitylivingbase).func_71064_a((StatBase)ModAchievements.gaiaGuardianNoArmor, 1);
            }
        }
        this.func_184185_a(SoundEvents.field_187539_bB, 20.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(800.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public ResourceLocation func_184647_J() {
        return new ResourceLocation("Botania", this.isHardMode() ? "gaia_guardian_2" : "gaia_guardian");
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if ("player".equals(source.func_76355_l()) && source.func_76346_g() instanceof EntityPlayer) {
            this.trueKiller = (EntityPlayer)source.func_76346_g();
        }
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        for (EntityEquipmentSlot e : EntityEquipmentSlot.values()) {
            this.func_184201_a(e, null);
        }
        for (UUID u : this.playersWhoAttacked) {
            EntityPlayer player = this.field_70170_p.func_152378_a(u);
            if (player == null) continue;
            EntityPlayer saveLastAttacker = this.field_70717_bb;
            this.field_70717_bb = player;
            super.func_184610_a(wasRecentlyHit, lootingModifier, DamageSource.func_76365_a((EntityPlayer)player));
            this.field_70717_bb = saveLastAttacker;
        }
        this.trueKiller = null;
    }

    public void func_70106_y() {
        Botania.proxy.removeBoss(this);
        BlockPos source = this.getSource();
        Botania.proxy.playRecordClientSided(this.field_70170_p, source, null);
        isPlayingMusic = false;
        super.func_70106_y();
    }

    private List<EntityPlayer> getPlayersAround() {
        BlockPos source = this.getSource();
        float range = 15.0f;
        return this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)source.func_177958_n() + 0.5 - (double)range, (double)source.func_177956_o() + 0.5 - (double)range, (double)source.func_177952_p() + 0.5 - (double)range, (double)source.func_177958_n() + 0.5 + (double)range, (double)source.func_177956_o() + 0.5 + (double)range, (double)source.func_177952_p() + 0.5 + (double)range));
    }

    public void func_70636_d() {
        boolean spawnMissiles;
        boolean peaceful;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(BOSSINFO_ID, (Object)Optional.of((Object)this.bossInfo.func_186737_d()));
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
        if (!this.func_184188_bt().isEmpty()) {
            this.func_184210_p();
        }
        boolean bl = peaceful = this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL;
        if (!this.field_70170_p.field_72995_K && peaceful) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K) {
            int radius = 1;
            int posXInt = net.minecraft.util.math.MathHelper.func_76128_c((double)this.field_70165_t);
            int posYInt = net.minecraft.util.math.MathHelper.func_76128_c((double)this.field_70163_u);
            int posZInt = net.minecraft.util.math.MathHelper.func_76128_c((double)this.field_70161_v);
            for (int i = -radius; i < radius + 1; ++i) {
                for (int j = -radius; j < radius + 1; ++j) {
                    for (int k = -radius; k < radius + 1; ++k) {
                        int xp = posXInt + i;
                        int yp = posYInt + j;
                        int zp = posZInt + k;
                        BlockPos posp = new BlockPos(xp, yp, zp);
                        if (!EntityDoppleganger.isCheatyBlock(this.field_70170_p, posp)) continue;
                        Block block = this.field_70170_p.func_180495_p(posp).func_177230_c();
                        List items = block.getDrops((IBlockAccess)this.field_70170_p, posp, this.field_70170_p.func_180495_p(posp), 0);
                        for (ItemStack stack : items) {
                            if (ConfigHandler.blockBreakParticles) {
                                this.field_70170_p.func_175718_b(2001, posp, Block.func_176210_f((IBlockState)this.field_70170_p.func_180495_p(posp)));
                            }
                            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, (double)xp + 0.5, (double)yp + 0.5, (double)zp + 0.5, stack));
                        }
                        this.field_70170_p.func_175698_g(posp);
                    }
                }
            }
        }
        BlockPos source = this.getSource();
        boolean hard = this.isHardMode();
        List players = this.getPlayersAround();
        int playerCount = this.getPlayerCount();
        if (this.field_70170_p.field_72995_K && !isPlayingMusic && !this.field_70128_L && !players.isEmpty()) {
            Botania.proxy.playRecordClientSided(this.field_70170_p, source, (ItemRecord)(hard ? ModItems.recordGaia2 : ModItems.recordGaia1));
            isPlayingMusic = true;
        }
        float range = 12.0f;
        for (int i = 0; i < 360; i += 8) {
            float r = 0.6f;
            float g = 0.0f;
            float b = 0.2f;
            float m = 0.15f;
            float mv = 0.35f;
            float rad = (float)i * (float)Math.PI / 180.0f;
            double x = (double)source.func_177958_n() + 0.5 - Math.cos(rad) * (double)range;
            double y = (double)source.func_177956_o() + 0.5;
            double z = (double)source.func_177952_p() + 0.5 - Math.sin(rad) * (double)range;
            Botania.proxy.wispFX(this.field_70170_p, x, y, z, r, g, b, 0.5f, (float)(Math.random() - 0.5) * m, (float)(Math.random() - 0.5) * mv, (float)(Math.random() - 0.5) * m);
        }
        if (players.isEmpty() && !this.field_70170_p.field_73010_i.isEmpty()) {
            this.func_70106_y();
        } else {
            for (EntityPlayer player : players) {
                if (player.field_71071_by.field_70460_b[0] != null || player.field_71071_by.field_70460_b[1] != null || player.field_71071_by.field_70460_b[2] != null || player.field_71071_by.field_70460_b[3] != null) {
                    this.anyWithArmor = true;
                }
                ArrayList<PotionEffect> remove = new ArrayList<PotionEffect>();
                Collection active = player.func_70651_bq();
                for (PotionEffect effect : active) {
                    if (effect.func_76459_b() >= 200 || !effect.func_82720_e() || effect.func_188419_a().func_76398_f()) continue;
                    remove.add(effect);
                }
                active.removeAll(remove);
                boolean bl2 = player.field_71075_bZ.field_75100_b = player.field_71075_bZ.field_75100_b && player.field_71075_bZ.field_75098_d;
                if (!(MathHelper.pointDistanceSpace(player.field_70165_t, player.field_70163_u, player.field_70161_v, (double)source.func_177958_n() + 0.5, (double)source.func_177956_o() + 0.5, (double)source.func_177952_p() + 0.5) >= range)) continue;
                Vector3 sourceVector = new Vector3((double)source.func_177958_n() + 0.5, (double)source.func_177956_o() + 0.5, (double)source.func_177952_p() + 0.5);
                Vector3 playerVector = Vector3.fromEntityCenter((Entity)player);
                Vector3 motion = sourceVector.copy().sub(playerVector).copy().normalize();
                player.field_70159_w = motion.x;
                player.field_70181_x = 0.2;
                player.field_70179_y = motion.z;
            }
        }
        if (this.field_70128_L) {
            return;
        }
        int invul = this.getInvulTime();
        int mobTicks = this.getMobSpawnTicks();
        boolean bl3 = spawnMissiles = hard && this.field_70173_aa % 15 < 4;
        if (invul > 10) {
            Vector3 pos = Vector3.fromEntityCenter((Entity)this).subtract(new Vector3(0.0, 0.2, 0.0));
            for (int i = 0; i < PYLON_LOCATIONS.length; ++i) {
                BlockPos arr = PYLON_LOCATIONS[i];
                Vector3 pylonPos = new Vector3(source.func_177958_n() + arr.func_177958_n(), source.func_177956_o() + arr.func_177956_o(), source.func_177952_p() + arr.func_177952_p());
                double worldTime = this.field_70173_aa;
                float rad = 0.75f + (float)Math.random() * 0.05f;
                double xp = pylonPos.x + 0.5 + Math.cos(worldTime /= 5.0) * (double)rad;
                double zp = pylonPos.z + 0.5 + Math.sin(worldTime) * (double)rad;
                Vector3 partPos = new Vector3(xp, pylonPos.y, zp);
                Vector3 mot = pos.copy().sub(partPos).multiply(0.04);
                float r = 0.7f + (float)Math.random() * 0.3f;
                float g = (float)Math.random() * 0.3f;
                float b = 0.7f + (float)Math.random() * 0.3f;
                Botania.proxy.wispFX(this.field_70170_p, partPos.x, partPos.y, partPos.z, r, g, b, 0.25f + (float)Math.random() * 0.1f, -0.075f - (float)Math.random() * 0.015f);
                Botania.proxy.wispFX(this.field_70170_p, partPos.x, partPos.y, partPos.z, r, g, b, 0.4f, (float)mot.x, (float)mot.y, (float)mot.z);
            }
        }
        if (invul > 0 && mobTicks == 900) {
            if (invul < 160 && invul > 80 && this.field_70170_p.field_73012_v.nextInt(160 - invul + 1) == 0) {
                for (int i = 0; i < 2; ++i) {
                    this.func_70656_aK();
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70606_j(this.func_110143_aJ() + (this.func_110138_aP() - 1.0f) / 160.0f);
                this.setInvulTime(invul - 1);
            }
            this.field_70181_x = 0.0;
        } else if (this.isAggroed()) {
            boolean dying;
            boolean bl4 = dying = (double)(this.func_110143_aJ() / this.func_110138_aP()) < 0.2;
            if (dying && mobTicks > 0) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                int reverseTicks = 900 - mobTicks;
                if (reverseTicks < 20) {
                    this.field_70181_x = 0.2;
                    this.setInvulTime(invul + 1);
                }
                if (reverseTicks > 40 && mobTicks > 80 && mobTicks % 80 == 0 && !this.field_70170_p.field_72995_K) {
                    for (int pl = 0; pl < playerCount; ++pl) {
                        for (int i = 0; i < 3 + this.field_70170_p.field_73012_v.nextInt(2); ++i) {
                            EntityZombie entity = null;
                            switch (this.field_70170_p.field_73012_v.nextInt(2)) {
                                case 0: {
                                    entity = new EntityZombie(this.field_70170_p);
                                    if (this.field_70170_p.field_73012_v.nextInt(hard ? 3 : 12) != 0) break;
                                    entity = new EntityWitch(this.field_70170_p);
                                    break;
                                }
                                case 1: {
                                    entity = new EntitySkeleton(this.field_70170_p);
                                    entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                                    if (this.field_70170_p.field_73012_v.nextInt(8) != 0) break;
                                    ((EntitySkeleton)entity).func_82201_a(1);
                                    entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(hard ? ModItems.elementiumSword : Items.field_151052_q));
                                    break;
                                }
                                case 3: {
                                    if (players.isEmpty()) break;
                                    for (int j = 0; j < 1 + this.field_70170_p.field_73012_v.nextInt(hard ? 8 : 5); ++j) {
                                        EntityPixie pixie = new EntityPixie(this.field_70170_p);
                                        pixie.setProps((EntityLivingBase)players.get(this.field_70146_Z.nextInt(players.size())), (EntityLivingBase)this, 1, 8.0f);
                                        pixie.func_70107_b(this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u + 2.0, this.field_70161_v + (double)(this.field_70130_N / 2.0f));
                                        this.field_70170_p.func_72838_d((Entity)pixie);
                                    }
                                    break;
                                }
                            }
                            if (entity == null) continue;
                            range = 6.0f;
                            entity.func_70107_b(this.field_70165_t + 0.5 + Math.random() * (double)range - (double)(range / 2.0f), this.field_70163_u - 1.0, this.field_70161_v + 0.5 + Math.random() * (double)range - (double)(range / 2.0f));
                            this.field_70170_p.func_72838_d((Entity)entity);
                        }
                    }
                    if (hard && this.field_70173_aa % 3 < 2) {
                        for (int i = 0; i < playerCount; ++i) {
                            this.spawnMissile();
                        }
                        spawnMissiles = false;
                    }
                }
                this.setMobSpawnTicks(mobTicks - 1);
                this.setTPDelay(10);
            } else if (this.getTPDelay() > 0 && !this.field_70170_p.field_72995_K) {
                if (invul > 0) {
                    this.setInvulTime(invul - 1);
                }
                this.setTPDelay(this.getTPDelay() - 1);
                if (this.getTPDelay() == 0 && this.func_110143_aJ() > 0.0f) {
                    int tries;
                    for (tries = 0; !this.teleportRandomly() && tries < 50; ++tries) {
                    }
                    if (tries >= 50) {
                        this.teleportTo((double)source.func_177958_n() + 0.5, (double)source.func_177956_o() + 1.6, (double)source.func_177952_p() + 0.5);
                    }
                    if (this.spawnLandmines) {
                        int count = dying && hard ? 7 : 6;
                        for (int i = 0; i < count; ++i) {
                            int x = source.func_177958_n() - 10 + this.field_70146_Z.nextInt(20);
                            int z = source.func_177952_p() - 10 + this.field_70146_Z.nextInt(20);
                            int y = this.field_70170_p.func_175672_r(new BlockPos(x, -1, z)).func_177956_o();
                            EntityMagicLandmine landmine = new EntityMagicLandmine(this.field_70170_p);
                            landmine.func_70107_b((double)x + 0.5, y, (double)z + 0.5);
                            landmine.summoner = this;
                            this.field_70170_p.func_72838_d((Entity)landmine);
                        }
                    }
                    if (!players.isEmpty()) {
                        for (int pl = 0; pl < playerCount; ++pl) {
                            for (int i = 0; i < (this.spawnPixies ? this.field_70170_p.field_73012_v.nextInt(hard ? 6 : 3) : 1); ++i) {
                                EntityPixie pixie = new EntityPixie(this.field_70170_p);
                                pixie.setProps((EntityLivingBase)players.get(this.field_70146_Z.nextInt(players.size())), (EntityLivingBase)this, 1, 8.0f);
                                pixie.func_70107_b(this.field_70165_t + (double)(this.field_70130_N / 2.0f), this.field_70163_u + 2.0, this.field_70161_v + (double)(this.field_70130_N / 2.0f));
                                this.field_70170_p.func_72838_d((Entity)pixie);
                            }
                        }
                    }
                    this.setTPDelay(hard ? (dying ? 35 : 45) : (dying ? 40 : 60));
                    this.spawnLandmines = true;
                    this.spawnPixies = false;
                }
            }
            if (spawnMissiles) {
                this.spawnMissile();
            }
        } else {
            range = 3.0f;
            players = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_70165_t - (double)range, this.field_70163_u - (double)range, this.field_70161_v - (double)range, this.field_70165_t + (double)range, this.field_70163_u + (double)range, this.field_70161_v + (double)range));
            if (!players.isEmpty()) {
                this.func_70665_d(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)players.get(0))), 0.0f);
            }
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    private void spawnMissile() {
        if (!this.field_70170_p.field_72995_K) {
            EntityMagicMissile missile = new EntityMagicMissile((EntityLivingBase)this, true);
            missile.func_70107_b(this.field_70165_t + (Math.random() - 0.05), this.field_70163_u + 2.4 + (Math.random() - 0.05), this.field_70161_v + (Math.random() - 0.05));
            if (missile.getTarget()) {
                this.func_184185_a(BotaniaSoundEvents.missile, 0.6f, 0.8f + (float)Math.random() * 0.2f);
                this.field_70170_p.func_72838_d((Entity)missile);
            }
        }
    }

    private static boolean isCheatyBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
        return CHEATY_BLOCKS.contains(name);
    }

    private boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    private boolean teleportTo(double par1, double par3, double par5) {
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        boolean flag = false;
        BlockPos pos = new BlockPos((Entity)this);
        if (this.field_70170_p.func_175667_e(pos)) {
            boolean flag1 = false;
            while (!flag1 && pos.func_177956_o() > 0) {
                IBlockState state = this.field_70170_p.func_180495_p(pos.func_177977_b());
                Block block = state.func_177230_c();
                if (block.func_149688_o(state).func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                pos = pos.func_177977_b();
            }
            if (flag1) {
                BlockPos source;
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
                if (MathHelper.pointDistanceSpace(this.field_70165_t, this.field_70163_u, this.field_70161_v, (source = this.getSource()).func_177958_n(), source.func_177956_o(), source.func_177952_p()) > 12.0f) {
                    flag = false;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
        }
        this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getBossBarTexture() {
        return BossBarHandler.defaultBossBar;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Rectangle getBossBarTextureRect() {
        if (barRect == null) {
            barRect = new Rectangle(0, 0, 185, 15);
        }
        return barRect;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Rectangle getBossBarHPTextureRect() {
        if (hpBarRect == null) {
            hpBarRect = new Rectangle(0, EntityDoppleganger.barRect.y + EntityDoppleganger.barRect.height, 181, 7);
        }
        return hpBarRect;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int bossBarRenderCallback(ScaledResolution res, int x, int y) {
        GlStateManager.func_179094_E();
        int px = x + 160;
        int py = y + 12;
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = new ItemStack(Items.field_151144_bL, 1, 3);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        mc.func_175599_af().func_175042_a(stack, px, py);
        RenderHelper.func_74518_a();
        boolean unicode = mc.field_71466_p.func_82883_a();
        mc.field_71466_p.func_78264_a(true);
        mc.field_71466_p.func_175063_a("" + this.getPlayerCount(), (float)(px + 15), (float)(py + 4), 0xFFFFFF);
        mc.field_71466_p.func_78264_a(unicode);
        GlStateManager.func_179121_F();
        return 5;
    }

    @Override
    public UUID getBossInfoUuid() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(BOSSINFO_ID)).or((Object)new UUID(0L, 0L));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getBossBarShaderProgram(boolean background) {
        return background ? 0 : ShaderHelper.dopplegangerBar;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ShaderCallback getBossBarShaderCallback(boolean background, int shader) {
        if (this.shaderCallback == null) {
            this.shaderCallback = shader1 -> {
                int grainIntensityUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader1, (CharSequence)"grainIntensity");
                int hpFractUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader1, (CharSequence)"hpFract");
                float time = this.getInvulTime();
                float grainIntensity = time > 20.0f ? 1.0f : Math.max(this.isHardMode() ? 0.5f : 0.0f, time / 20.0f);
                ARBShaderObjects.glUniform1fARB((int)grainIntensityUniform, (float)grainIntensity);
                ARBShaderObjects.glUniform1fARB((int)hpFractUniform, (float)(this.func_110143_aJ() / this.func_110138_aP()));
            };
        }
        return background ? null : this.shaderCallback;
    }

    private static class BeaconBeamComponent
    extends MultiblockComponent {
        public BeaconBeamComponent(BlockPos relPos) {
            super(relPos, Blocks.field_150461_bJ.func_176223_P());
        }

        @Override
        public boolean matches(World world, BlockPos pos) {
            return world.func_175625_s(pos) instanceof TileEntityBeacon;
        }
    }

    private static class BeaconComponent
    extends MultiblockComponent {
        public BeaconComponent(BlockPos relPos) {
            super(relPos, Blocks.field_150339_S.func_176223_P());
        }

        @Override
        public boolean matches(World world, BlockPos pos) {
            return world.func_180495_p(pos).func_177230_c().isBeaconBase((IBlockAccess)world, pos, pos.func_177971_a((Vec3i)new BlockPos(-this.relPos.func_177958_n(), -this.relPos.func_177956_o(), -this.relPos.func_177952_p())));
        }
    }
}

