/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.mana.TilePump;
import vazkii.botania.common.item.ModItems;

public class EntityPoolMinecart
extends EntityMinecart {
    private static final int TRANSFER_RATE = 10000;
    private static final String TAG_MANA = "mana";
    private static final DataParameter<Integer> MANA = EntityDataManager.func_187226_a(EntityPoolMinecart.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityPoolMinecart(World p_i1712_1_) {
        super(p_i1712_1_);
    }

    public EntityPoolMinecart(World p_i1715_1_, double p_i1715_2_, double p_i1715_4_, double p_i1715_6_) {
        super(p_i1715_1_, p_i1715_2_, p_i1715_4_, p_i1715_6_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MANA, (Object)0);
    }

    public IBlockState func_174897_t() {
        return ModBlocks.pool.func_176223_P();
    }

    public ItemStack getCartItem() {
        return new ItemStack(ModItems.poolMinecart);
    }

    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.RIDEABLE;
    }

    public boolean canBeRidden() {
        return false;
    }

    public void func_94095_a(DamageSource p_94095_1_) {
        super.func_94095_a(p_94095_1_);
        this.func_145778_a(Item.func_150898_a((Block)ModBlocks.pool), 1, 0.0f);
    }

    public int func_94085_r() {
        return 8;
    }

    public void moveMinecartOnRail(BlockPos pos) {
        super.moveMinecartOnRail(pos);
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            int cartMana;
            BlockPos posP = pos.func_177972_a(dir);
            Block block = this.field_70170_p.func_180495_p(posP).func_177230_c();
            if (block != ModBlocks.pump) continue;
            BlockPos posP_ = posP.func_177972_a(dir);
            TileEntity tile = this.field_70170_p.func_175625_s(posP_);
            TileEntity tile_ = this.field_70170_p.func_175625_s(posP);
            TilePump pump = (TilePump)tile_;
            if (tile == null || !(tile instanceof IManaPool) || pump.hasRedstone) continue;
            IManaPool pool = (IManaPool)tile;
            EnumFacing pumpDir = (EnumFacing)this.field_70170_p.func_180495_p(posP).func_177229_b(BotaniaStateProps.CARDINALS);
            boolean did = false;
            boolean can = false;
            if (pumpDir == dir) {
                int poolMana;
                int transfer;
                can = true;
                cartMana = this.getMana();
                int actualTransfer = Math.min(1000000 - cartMana, transfer = Math.min(10000, poolMana = pool.getCurrentMana()));
                if (actualTransfer > 0) {
                    pool.recieveMana(-transfer);
                    this.setMana(cartMana + actualTransfer);
                    did = true;
                }
            } else if (pumpDir == dir.func_176734_d()) {
                int transfer;
                can = true;
                if (!pool.isFull() && (transfer = Math.min(10000, cartMana = this.getMana())) > 0) {
                    pool.recieveMana(transfer);
                    this.setMana(cartMana - transfer);
                    did = true;
                }
            }
            if (did) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_70170_p, posP_);
                pump.hasCart = true;
                if (!pump.active) {
                    pump.setActive(true);
                }
            }
            if (!can) continue;
            pump.hasCartOnTop = true;
            pump.comparator = (int)((double)this.getMana() / 1000000.0 * 15.0);
        }
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
        super.func_70014_b(p_70014_1_);
        p_70014_1_.func_74768_a(TAG_MANA, this.getMana());
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.setMana(p_70037_1_.func_74762_e(TAG_MANA));
    }

    public int getMana() {
        return (Integer)this.field_70180_af.func_187225_a(MANA);
    }

    public void setMana(int mana) {
        this.field_70180_af.func_187227_b(MANA, (Object)mana);
    }
}

