/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;

public class EntityThornChakram
extends EntityThrowable {
    private static final DataParameter<Integer> BOUNCES = EntityDataManager.func_187226_a(EntityThornChakram.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> FLARE = EntityDataManager.func_187226_a(EntityThornChakram.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final int MAX_BOUNCES = 16;
    boolean bounced = false;
    private ItemStack stack;

    public EntityThornChakram(World world) {
        super(world);
    }

    public EntityThornChakram(World world, EntityLivingBase e, ItemStack stack) {
        super(world, e);
        this.stack = stack.func_77946_l();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BOUNCES, (Object)0);
        this.field_70180_af.func_187214_a(FLARE, (Object)false);
    }

    public void func_70071_h_() {
        int bounces;
        double mx = this.field_70159_w;
        double my = this.field_70181_x;
        double mz = this.field_70179_y;
        super.func_70071_h_();
        if (this.isFire()) {
            double r = 0.1;
            double m = 0.1;
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + r * (Math.random() - 0.5), this.field_70163_u + r * (Math.random() - 0.5), this.field_70161_v + r * (Math.random() - 0.5), m * (Math.random() - 0.5), m * (Math.random() - 0.5), m * (Math.random() - 0.5), new int[0]);
            }
        }
        if ((bounces = this.getTimesBounced()) >= 16 || this.field_70173_aa > 60) {
            EntityLivingBase thrower = this.func_85052_h();
            this.field_70145_X = true;
            if (thrower == null) {
                this.dropAndKill();
            } else {
                Vector3 motion = Vector3.fromEntityCenter((Entity)thrower).sub(Vector3.fromEntityCenter((Entity)this)).normalize();
                this.field_70159_w = motion.x;
                this.field_70181_x = motion.y;
                this.field_70179_y = motion.z;
                if (!this.field_70170_p.field_72995_K && MathHelper.pointDistanceSpace(this.field_70165_t, this.field_70163_u, this.field_70161_v, thrower.field_70165_t, thrower.field_70163_u, thrower.field_70161_v) < 1.0f) {
                    if (!(thrower instanceof EntityPlayer) || !((EntityPlayer)thrower).field_71075_bZ.field_75098_d && !((EntityPlayer)thrower).field_71071_by.func_70441_a(this.getItemStack())) {
                        this.dropAndKill();
                    } else {
                        this.func_70106_y();
                    }
                }
            }
        } else {
            if (!this.bounced) {
                this.field_70159_w = mx;
                this.field_70181_x = my;
                this.field_70179_y = mz;
            }
            this.bounced = false;
        }
    }

    private void dropAndKill() {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = this.getItemStack();
            EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
            this.field_70170_p.func_72838_d((Entity)item);
            this.func_70106_y();
        }
    }

    private ItemStack getItemStack() {
        return this.stack != null ? this.stack.func_77946_l() : new ItemStack(ModItems.thornChakram, 1, this.isFire() ? 1 : 0);
    }

    protected void func_70184_a(RayTraceResult pos) {
        int bounces;
        if (this.field_70145_X) {
            return;
        }
        if (pos.func_178782_a() != null) {
            Block block = this.field_70170_p.func_180495_p(pos.func_178782_a()).func_177230_c();
            this.field_70170_p.func_175625_s(pos.func_178782_a());
            if (block instanceof BlockBush || block instanceof BlockLeaves) {
                return;
            }
        }
        boolean fire = this.isFire();
        EntityLivingBase thrower = this.func_85052_h();
        if (!this.field_70170_p.field_72995_K && pos.field_72308_g != null && pos.field_72308_g instanceof EntityLivingBase && pos.field_72308_g != thrower) {
            pos.field_72308_g.func_70097_a(thrower != null ? (thrower instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)thrower)) : DamageSource.func_76358_a((EntityLivingBase)thrower)) : DamageSource.field_76377_j, 12.0f);
            if (fire) {
                pos.field_72308_g.func_70015_d(5);
            } else if (this.field_70170_p.field_73012_v.nextInt(3) == 0) {
                ((EntityLivingBase)pos.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 60, 0));
            }
        } else if (pos.func_178782_a() != null && (bounces = this.getTimesBounced()) < 16) {
            Vector3 currentMovementVec = new Vector3(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            EnumFacing dir = pos.field_178784_b;
            Vector3 normalVector = new Vector3(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e()).normalize();
            Vector3 movementVec = normalVector.multiply(-2.0 * currentMovementVec.dotProduct(normalVector)).add(currentMovementVec);
            this.field_70159_w = movementVec.x;
            this.field_70181_x = movementVec.y;
            this.field_70179_y = movementVec.z;
            this.bounced = true;
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public int getTimesBounced() {
        return (Integer)this.field_70180_af.func_187225_a(BOUNCES);
    }

    public void setTimesBounced(int times) {
        this.field_70180_af.func_187227_b(BOUNCES, (Object)times);
    }

    public boolean isFire() {
        return (Boolean)this.field_70180_af.func_187225_a(FLARE);
    }

    public void setFire(boolean fire) {
        this.field_70180_af.func_187227_b(FLARE, (Object)fire);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.stack != null) {
            compound.func_74782_a("fly_stack", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("fly_stack")) {
            this.stack = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("fly_stack"));
        }
    }
}

