/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.corporea;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.corporea.IWrappedInventory;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.common.integration.corporea.WrappedInventoryBase;

public class WrappedIInventory
extends WrappedInventoryBase {
    private InvWithLocation inv;

    private WrappedIInventory(InvWithLocation inv, ICorporeaSpark spark) {
        this.inv = inv;
        this.spark = spark;
    }

    @Override
    public InvWithLocation getWrappedObject() {
        return this.inv;
    }

    @Override
    public List<ItemStack> countItems(CorporeaRequest request) {
        return this.iterateOverSlots(request, false);
    }

    @Override
    public List<ItemStack> extractItems(CorporeaRequest request) {
        return this.iterateOverSlots(request, true);
    }

    private List<ItemStack> iterateOverSlots(CorporeaRequest request, boolean doit) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = this.inv.handler.getSlots() - 1; i >= 0; --i) {
            ItemStack stackAt = this.inv.handler.getStackInSlot(i);
            if (!this.isMatchingItemStack(request.matcher, request.checkNBT, stackAt)) continue;
            int rem = Math.min(stackAt.field_77994_a, request.count == -1 ? stackAt.field_77994_a : request.count);
            if (rem > 0) {
                stacks.add(this.inv.handler.extractItem(i, rem, !doit));
                if (doit && this.spark != null) {
                    this.spark.onItemExtracted(stackAt);
                }
            }
            request.foundItems += stackAt.field_77994_a;
            request.extractedItems += rem;
            if (request.count == -1) continue;
            request.count -= rem;
        }
        return stacks;
    }

    public static IWrappedInventory wrap(InvWithLocation inv, ICorporeaSpark spark) {
        return new WrappedIInventory(inv, spark);
    }
}

