/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.IRecipeKeyProvider;
import vazkii.botania.api.subtile.signature.SubTileSignature;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileSpecialFlower;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.block.ItemBlockMod;

public class ItemBlockSpecialFlower
extends ItemBlockMod
implements IRecipeKeyProvider {
    public ItemBlockSpecialFlower(Block block1) {
        super(block1);
        this.func_77627_a(true);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        boolean placed = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (placed) {
            String type = ItemBlockSpecialFlower.getType(stack);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileSpecialFlower) {
                TileSpecialFlower tile = (TileSpecialFlower)te;
                tile.setSubTile(type);
                tile.onBlockAdded(world, pos, newState);
                tile.onBlockPlacedBy(world, pos, newState, (EntityLivingBase)player, stack);
                if (!world.field_72995_K) {
                    world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 8);
                }
            }
        }
        return placed;
    }

    public String func_77667_c(ItemStack stack) {
        return BotaniaAPI.getSignatureForName(ItemBlockSpecialFlower.getType(stack)).getUnlocalizedNameForStack(stack);
    }

    @Override
    public String func_77657_g(ItemStack par1ItemStack) {
        return this.getUnlocalizedNameInefficiently_(par1ItemStack);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
        String mod;
        String refUnlocalized;
        String refLocalized;
        String type = ItemBlockSpecialFlower.getType(par1ItemStack);
        SubTileSignature sig = BotaniaAPI.getSignatureForName(type);
        sig.addTooltip(par1ItemStack, par2EntityPlayer, par3List);
        if (ConfigHandler.referencesEnabled && !(refLocalized = I18n.func_74838_a((String)(refUnlocalized = sig.getUnlocalizedLoreTextForStack(par1ItemStack)))).equals(refUnlocalized)) {
            par3List.add(TextFormatting.ITALIC + refLocalized);
        }
        if (!(mod = BotaniaAPI.subTileMods.get(type)).equals("Botania")) {
            par3List.add(TextFormatting.ITALIC + "[" + mod + "]");
        }
    }

    public static String getType(ItemStack stack) {
        return ItemNBTHelper.detectNBT(stack) ? ItemNBTHelper.getString(stack, "type", "") : "";
    }

    public static ItemStack ofType(String type) {
        return ItemBlockSpecialFlower.ofType(new ItemStack(ModBlocks.specialFlower), type);
    }

    public static ItemStack ofType(ItemStack stack, String type) {
        ItemNBTHelper.setString(stack, "type", type);
        return stack;
    }

    @Override
    public String getKey(ItemStack stack) {
        return "flower." + ItemBlockSpecialFlower.getType(stack);
    }

    @Override
    public Achievement getAchievementOnPickup(ItemStack stack, EntityPlayer player, EntityItem item) {
        String type;
        switch (type = ItemBlockSpecialFlower.getType(stack)) {
            case "daybloom": {
                return ModAchievements.daybloomPickup;
            }
            case "endoflame": {
                return ModAchievements.endoflamePickup;
            }
            case "kekimurus": {
                return ModAchievements.kekimurusPickup;
            }
            case "heiseiDream": {
                return ModAchievements.heiseiDreamPickup;
            }
            case "pollidisiac": {
                return ModAchievements.pollidisiacPickup;
            }
            case "bubbell": {
                return ModAchievements.bubbellPickup;
            }
            case "dandelifeon": {
                return ModAchievements.dandelifeonPickup;
            }
            case "": {
                return ModAchievements.nullFlower;
            }
        }
        return null;
    }
}

