/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.brew;

import java.awt.Color;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.achievement.IPickupAchievement;
import vazkii.botania.common.achievement.ModAchievements;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.IColorable;
import vazkii.botania.common.item.ItemMod;

public abstract class ItemBrewBase
extends ItemMod
implements IBrewItem,
IPickupAchievement,
IColorable {
    private static final String TAG_BREW_KEY = "brewKey";
    private static final String TAG_SWIGS_LEFT = "swigsLeft";
    private String name;
    private String texName;
    private int swigs;
    private int drinkSpeed;
    private ItemStack baseItem;

    public ItemBrewBase(String name, String texName, int swigs, int drinkSpeed, ItemStack baseItem) {
        super(name);
        this.name = name;
        this.texName = texName;
        this.swigs = swigs;
        this.drinkSpeed = drinkSpeed;
        this.baseItem = baseItem;
        this.func_77625_d(1);
        this.func_77656_e(swigs);
        this.setNoRepair();
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return this.drinkSpeed;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack p_77659_1_, World p_77659_2_, EntityPlayer p_77659_3_, EnumHand hand) {
        p_77659_3_.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)p_77659_1_);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase living) {
        if (!world.field_72995_K) {
            for (PotionEffect effect : this.getBrew(stack).getPotionEffects(stack)) {
                PotionEffect newEffect = new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c(), true, true);
                if (effect.func_188419_a().func_76403_b()) {
                    effect.func_188419_a().func_180793_a((Entity)living, (Entity)living, living, newEffect.func_76458_c(), 1.0);
                    continue;
                }
                living.func_70690_d(newEffect);
            }
            if (world.field_73012_v.nextBoolean()) {
                world.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            int swigs = this.getSwigsLeft(stack);
            if (living instanceof EntityPlayer && !((EntityPlayer)living).field_71075_bZ.field_75098_d) {
                if (swigs == 1) {
                    if (!((EntityPlayer)living).field_71071_by.func_70441_a(this.baseItem.func_77946_l())) {
                        return this.baseItem.func_77946_l();
                    }
                    ItemStack copy = stack.func_77946_l();
                    copy.field_77994_a = 0;
                    return copy;
                }
                this.setSwigsLeft(stack, swigs - 1);
            }
        }
        return stack;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (String s : BotaniaAPI.brewMap.keySet()) {
            ItemStack stack = new ItemStack(item);
            ItemBrewBase.setBrew(stack, s);
            list.add(stack);
        }
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int pass) {
        if (pass == 0) {
            return 0xFFFFFF;
        }
        Color color = new Color(this.getBrew(stack).getColor(stack));
        int add = (int)(Math.sin((double)ClientTickHandler.ticksInGame * 0.1) * 16.0);
        int r = Math.max(0, Math.min(255, color.getRed() + add));
        int g = Math.max(0, Math.min(255, color.getGreen() + add));
        int b = Math.max(0, Math.min(255, color.getBlue() + add));
        return r << 16 | g << 8 | b;
    }

    public String func_77653_i(ItemStack stack) {
        return String.format(I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name")), I18n.func_74838_a((String)this.getBrew(stack).getUnlocalizedName(stack)), TextFormatting.BOLD + "" + this.getSwigsLeft(stack) + TextFormatting.RESET);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean adv) {
        Brew brew = this.getBrew(stack);
        for (PotionEffect effect : brew.getPotionEffects(stack)) {
            TextFormatting format = effect.func_188419_a().func_76398_f() ? TextFormatting.RED : TextFormatting.GRAY;
            list.add(format + I18n.func_74838_a((String)effect.func_76453_d()) + (effect.func_76458_c() == 0 ? "" : " " + I18n.func_74838_a((String)("botania.roman" + (effect.func_76458_c() + 1)))) + TextFormatting.GRAY + (effect.func_188419_a().func_76403_b() ? "" : " (" + Potion.func_188410_a((PotionEffect)effect, (float)1.0f) + ")"));
        }
    }

    @Override
    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
        return BotaniaAPI.getBrewFromKey(key);
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        ItemBrewBase.setBrew(stack, (brew == null ? BotaniaAPI.fallbackBrew : brew).getKey());
    }

    public static void setBrew(ItemStack stack, String brew) {
        ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew);
    }

    public int getSwigsLeft(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_SWIGS_LEFT, this.swigs);
    }

    public void setSwigsLeft(ItemStack stack, int swigs) {
        ItemNBTHelper.setInt(stack, TAG_SWIGS_LEFT, swigs);
    }

    @Override
    public Achievement getAchievementOnPickup(ItemStack stack, EntityPlayer player, EntityItem item) {
        return ModAchievements.brewPickup;
    }
}

