/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.elementium;

import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IPixieSpawner;
import vazkii.botania.client.model.armor.ModelArmorElementium;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;

public abstract class ItemElementiumArmor
extends ItemManasteelArmor
implements IPixieSpawner {
    static ItemStack[] armorset;

    public ItemElementiumArmor(EntityEquipmentSlot type, String name) {
        super(type, name, BotaniaAPI.elementiumArmorMaterial);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped provideArmorModelForSlot(ItemStack stack, EntityEquipmentSlot slot) {
        this.models.put(slot, new ModelArmorElementium(slot));
        return (ModelBiped)this.models.get(slot);
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EntityEquipmentSlot slot) {
        return ConfigHandler.enableArmorModels ? "botania:textures/model/elementiumNew.png" : (slot == EntityEquipmentSlot.LEGS ? "botania:textures/model/elementium1.png" : "botania:textures/model/elementium0.png");
    }

    @Override
    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.manaResource && par2ItemStack.func_77952_i() == 7 ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        if (armorset == null) {
            armorset = new ItemStack[]{new ItemStack(ModItems.elementiumHelm), new ItemStack(ModItems.elementiumChest), new ItemStack(ModItems.elementiumLegs), new ItemStack(ModItems.elementiumBoots)};
        }
        return armorset;
    }

    @Override
    public boolean hasArmorSetItem(EntityPlayer player, int i) {
        ItemStack stack = player.field_71071_by.field_70460_b[3 - i];
        if (stack == null) {
            return false;
        }
        switch (i) {
            case 0: {
                return stack.func_77973_b() == ModItems.elementiumHelm || stack.func_77973_b() == ModItems.elementiumHelmRevealing;
            }
            case 1: {
                return stack.func_77973_b() == ModItems.elementiumChest;
            }
            case 2: {
                return stack.func_77973_b() == ModItems.elementiumLegs;
            }
            case 3: {
                return stack.func_77973_b() == ModItems.elementiumBoots;
            }
        }
        return false;
    }

    @Override
    public String getArmorSetName() {
        return I18n.func_74838_a((String)"botania.armorset.elementium.name");
    }

    @Override
    public void addArmorSetDescription(ItemStack stack, List<String> list) {
        super.addArmorSetDescription(stack, list);
        this.addStringToTooltip(I18n.func_74838_a((String)"botania.armorset.elementium.desc"), list);
    }
}

