/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.item.IAncientWillContainer;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.api.mana.IManaDiscountArmor;
import vazkii.botania.api.mana.IManaGivingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelArmor;

public class ItemTerrasteelHelm
extends ItemTerrasteelArmor
implements IManaDiscountArmor,
IAncientWillContainer,
IManaGivingItem {
    private static final String TAG_ANCIENT_WILL = "AncientWill";

    public ItemTerrasteelHelm() {
        this("terrasteelHelm");
    }

    public ItemTerrasteelHelm(String name) {
        super(EntityEquipmentSlot.HEAD, name);
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (this.hasArmorSet(player)) {
            int food = player.func_71024_bL().func_75116_a();
            if (food > 0 && food < 18 && player.func_70996_bM() && player.field_70173_aa % 80 == 0) {
                player.func_70691_i(1.0f);
            }
            ManaItemHandler.dispatchManaExact(stack, player, 1, true);
        }
    }

    @Override
    public float getDiscount(ItemStack stack, int slot, EntityPlayer player) {
        return this.hasArmorSet(player) ? 0.2f : 0.0f;
    }

    @Override
    public void addAncientWill(ItemStack stack, int will) {
        ItemNBTHelper.setBoolean(stack, TAG_ANCIENT_WILL + will, true);
    }

    @Override
    public boolean hasAncientWill(ItemStack stack, int will) {
        return ItemTerrasteelHelm.hasAncientWill_(stack, will);
    }

    public static boolean hasAncientWill_(ItemStack stack, int will) {
        return ItemNBTHelper.getBoolean(stack, TAG_ANCIENT_WILL + will, false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addArmorSetDescription(ItemStack stack, List<String> list) {
        super.addArmorSetDescription(stack, list);
        for (int i = 0; i < 6; ++i) {
            if (!this.hasAncientWill(stack, i)) continue;
            this.addStringToTooltip(I18n.func_74838_a((String)("botania.armorset.will" + i + ".desc")), list);
        }
    }

    public static boolean hasAnyWill(ItemStack stack) {
        for (int i = 0; i < 6; ++i) {
            if (!ItemTerrasteelHelm.hasAncientWill_(stack, i)) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderOnPlayer(ItemStack stack, EntityPlayer player) {
        if (ItemTerrasteelHelm.hasAnyWill(stack) && !((ItemTerrasteelArmor)stack.func_77973_b()).hasPhantomInk(stack)) {
            GlStateManager.func_179094_E();
            float f = MiscellaneousIcons.INSTANCE.terrasteelHelmWillIcon.func_94209_e();
            float f1 = MiscellaneousIcons.INSTANCE.terrasteelHelmWillIcon.func_94212_f();
            float f2 = MiscellaneousIcons.INSTANCE.terrasteelHelmWillIcon.func_94206_g();
            float f3 = MiscellaneousIcons.INSTANCE.terrasteelHelmWillIcon.func_94210_h();
            IBaubleRender.Helper.translateToHeadLevel(player);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.26f, (float)-1.45f, (float)-0.39f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, MiscellaneousIcons.INSTANCE.terrasteelHelmWillIcon.func_94211_a(), MiscellaneousIcons.INSTANCE.terrasteelHelmWillIcon.func_94216_b(), 0.0625f);
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingHurtEvent event) {
        EntityPlayer player;
        Entity attacker = event.getSource().func_76346_g();
        if (attacker instanceof EntityPlayer && this.hasArmorSet(player = (EntityPlayer)attacker)) {
            boolean crit = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(MobEffects.field_76440_q) && !player.func_184218_aH();
            ItemStack stack = player.field_71071_by.func_70440_f(3);
            if (crit && stack != null && stack.func_77973_b() instanceof ItemTerrasteelHelm) {
                boolean ahrim = this.hasAncientWill(stack, 0);
                boolean dharok = this.hasAncientWill(stack, 1);
                boolean guthan = this.hasAncientWill(stack, 2);
                boolean torag = this.hasAncientWill(stack, 3);
                boolean verac = this.hasAncientWill(stack, 4);
                boolean karil = this.hasAncientWill(stack, 5);
                if (ahrim) {
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76437_t, 20, 1));
                }
                if (dharok) {
                    event.setAmount(event.getAmount() * (1.0f + (1.0f - player.func_110143_aJ() / player.func_110138_aP()) * 0.5f));
                }
                if (guthan) {
                    player.func_70691_i(event.getAmount() * 0.25f);
                }
                if (torag) {
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60, 1));
                }
                if (verac) {
                    event.getSource().func_76348_h();
                }
                if (karil) {
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_82731_v, 60, 1));
                }
            }
        }
    }
}

