/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import baubles.api.BaubleType;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.api.item.ICosmeticBauble;
import vazkii.botania.common.crafting.recipe.CosmeticAttachRecipe;
import vazkii.botania.common.crafting.recipe.CosmeticRemoveRecipe;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemBaubleCosmetic
extends ItemBauble
implements ICosmeticBauble {
    private static final int SUBTYPES = 32;
    private final ItemStack renderStack;

    public ItemBaubleCosmetic() {
        super("cosmetic");
        this.func_77627_a(true);
        GameRegistry.addRecipe((IRecipe)new CosmeticAttachRecipe());
        GameRegistry.addRecipe((IRecipe)new CosmeticRemoveRecipe());
        RecipeSorter.register((String)"botania:cosmeticAttach", CosmeticAttachRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        RecipeSorter.register((String)"botania:cosmeticRemove", CosmeticRemoveRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        this.renderStack = new ItemStack((Item)this);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 32; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return super.func_77667_c(par1ItemStack) + par1ItemStack.func_77952_i();
    }

    @Override
    public void addHiddenTooltip(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List<String> par3List, boolean par4) {
        this.addStringToTooltip(I18n.func_74838_a((String)"botaniamisc.cosmeticBauble"), par3List);
        super.addHiddenTooltip(par1ItemStack, par2EntityPlayer, par3List, par4);
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.AMULET;
    }

    @Override
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IBaubleRender.RenderType type, float partialTicks) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (type == IBaubleRender.RenderType.HEAD) {
            IBaubleRender.Helper.translateToHeadLevel(player);
            switch (stack.func_77952_i()) {
                case 2: {
                    this.faceTranslate();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.045f);
                    this.renderIcon(2);
                    break;
                }
                case 4: {
                    this.faceTranslate();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.045f);
                    this.renderIcon(4);
                    break;
                }
                case 5: {
                    this.faceTranslate();
                    this.scale(0.35f);
                    GlStateManager.func_179109_b((float)-0.3f, (float)0.2f, (float)-0.5f);
                    this.renderIcon(5);
                    break;
                }
                case 6: {
                    this.faceTranslate();
                    this.scale(0.45f);
                    GlStateManager.func_179109_b((float)0.2f, (float)0.2f, (float)-0.4f);
                    this.renderIcon(6);
                    break;
                }
                case 7: {
                    this.faceTranslate();
                    this.scale(0.9f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.4f, (float)-0.42f);
                    this.renderIcon(7);
                    break;
                }
                case 8: {
                    this.faceTranslate();
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)-0.2f);
                    this.renderIcon(8);
                    break;
                }
                case 9: {
                    this.faceTranslate();
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)-0.1f);
                    this.renderIcon(9);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.45f, (float)0.0f);
                    this.renderIcon(9);
                    break;
                }
                case 10: {
                    this.faceTranslate();
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    this.scale(0.6f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.25f, (float)-0.4f);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)-0.2f, (float)0.15f, (float)0.0f);
                    GlStateManager.func_179114_b((float)-45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    this.renderIcon(10);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179109_b((float)0.15f, (float)0.3f, (float)0.0f);
                    GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    this.renderIcon(10);
                    break;
                }
                case 11: {
                    this.faceTranslate();
                    this.scale(0.6f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.55f);
                    this.renderIcon(11);
                    break;
                }
                case 15: {
                    this.faceTranslate();
                    GlStateManager.func_179109_b((float)-0.01f, (float)0.0f, (float)0.05f);
                    this.renderIcon(15);
                    break;
                }
                case 17: {
                    this.faceTranslate();
                    this.scale(0.35f);
                    GlStateManager.func_179109_b((float)0.25f, (float)0.2f, (float)-0.6f);
                    this.renderIcon(17);
                    break;
                }
                case 18: {
                    this.faceTranslate();
                    this.scale(0.75f);
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)-0.2f, (float)-0.15f, (float)-0.5f);
                    this.renderIcon(18);
                    break;
                }
                case 19: {
                    this.faceTranslate();
                    this.scale(0.6f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.5f);
                    this.renderIcon(19);
                    break;
                }
                case 20: {
                    this.faceTranslate();
                    this.scale(0.25f);
                    GlStateManager.func_179109_b((float)-0.7f, (float)0.3f, (float)-1.5f);
                    this.renderIcon(20);
                    GlStateManager.func_179109_b((float)1.4f, (float)0.0f, (float)0.0f);
                    this.renderIcon(20);
                    break;
                }
                case 22: {
                    this.faceTranslate();
                    this.renderIcon(22);
                    break;
                }
                case 23: {
                    this.faceTranslate();
                    this.renderIcon(23);
                    break;
                }
                case 24: {
                    this.faceTranslate();
                    this.scale(0.8f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.1f, (float)-0.5f);
                    this.renderIcon(24);
                    break;
                }
                case 25: {
                    this.faceTranslate();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.04f);
                    this.renderIcon(25);
                    break;
                }
                case 26: {
                    this.faceTranslate();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179112_b((int)770, (int)771);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                    this.renderIcon(26);
                    break;
                }
                case 27: {
                    this.faceTranslate();
                    this.scale(0.9f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.09f);
                    this.renderIcon(27);
                    break;
                }
                case 28: {
                    this.faceTranslate();
                    this.scale(0.25f);
                    GlStateManager.func_179109_b((float)-0.4f, (float)0.4f, (float)-1.1f);
                    this.renderIcon(28);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)-0.775f, (float)-0.4f, (float)0.04f);
                    this.renderIcon(28);
                    break;
                }
                case 30: {
                    this.faceTranslate();
                    this.renderIcon(30);
                    break;
                }
                case 31: {
                    this.faceTranslate();
                    this.scale(0.8f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.3f, (float)-0.75f);
                    this.renderIcon(31);
                }
            }
        } else {
            IBaubleRender.Helper.rotateIfSneaking(player);
            switch (stack.func_77952_i()) {
                case 0: {
                    this.chestTranslate();
                    this.renderIcon(0);
                    break;
                }
                case 1: {
                    this.chestTranslate();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.2f);
                    this.renderIcon(1);
                    break;
                }
                case 3: {
                    this.chestTranslate();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.15f);
                    this.renderIcon(3);
                    break;
                }
                case 12: {
                    this.chestTranslate();
                    this.scale(0.225f);
                    GlStateManager.func_179109_b((float)-0.725f, (float)0.45f, (float)-0.6f);
                    this.renderIcon(12);
                    break;
                }
                case 13: {
                    this.chestTranslate();
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.33f, (float)-0.15f, (float)0.55f);
                    this.renderIcon(13);
                    break;
                }
                case 14: {
                    this.chestTranslate();
                    this.scale(0.9f);
                    GlStateManager.func_179109_b((float)0.45f, (float)0.05f, (float)-0.1f);
                    this.renderIcon(14);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)0.9f, (float)-0.25f, (float)0.0f);
                    this.renderKamuiBlack();
                    break;
                }
                case 16: {
                    this.chestTranslate();
                    this.scale(0.225f);
                    GlStateManager.func_179109_b((float)0.725f, (float)0.45f, (float)-0.6f);
                    this.renderIcon(16);
                    break;
                }
                case 21: {
                    this.chestTranslate();
                    this.scale(0.5f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.15f, (float)0.32f);
                    this.renderIcon(21);
                    break;
                }
                case 29: {
                    this.chestTranslate();
                    GlStateManager.func_179109_b((float)0.05f, (float)-0.25f, (float)0.25f);
                    GlStateManager.func_179114_b((float)8.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    this.renderIcon(29);
                }
            }
        }
    }

    public void faceTranslate() {
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.25f, (float)1.25f, (float)1.25f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.1f, (float)1.45f);
    }

    public void chestTranslate() {
        GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public void scale(float f) {
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
    }

    public void renderIcon(int i) {
        GlStateManager.func_179094_E();
        this.renderStack.func_77964_b(i);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.renderStack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        GlStateManager.func_179121_F();
    }

    public void renderKamuiBlack() {
        this.renderStack.func_77964_b(14);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().field_71446_o.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(this.renderStack);
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179094_E();
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (boolean)false);
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.1f, (float)-0.4f);
        this.renderModel(model, this.renderStack, -16777140);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().field_71446_o.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    private void renderModel(IBakedModel model, ItemStack stack, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            this.renderQuads(worldrenderer, model.func_188616_a(null, enumfacing, 0L), color, stack);
        }
        this.renderQuads(worldrenderer, model.func_188616_a(null, null, 0L), color, stack);
        tessellator.func_78381_a();
    }

    private void renderQuads(VertexBuffer renderer, List<BakedQuad> quads, int color, ItemStack stack) {
        boolean flag = color == -1 && stack != null;
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((VertexBuffer)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }
}

