/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import baubles.api.BaubleType;
import baubles.common.lib.PlayerHandler;
import baubles.common.network.PacketHandler;
import baubles.common.network.PacketSyncBauble;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.lib.LibObfuscation;

public class ItemItemFinder
extends ItemBauble
implements IBaubleRender {
    private static final String TAG_POSITIONS = "highlightPositions";

    public ItemItemFinder() {
        super("itemFinder");
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        super.onWornTick(stack, player);
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            this.tickClient(stack, (EntityPlayer)player);
        } else {
            this.tickServer(stack, (EntityPlayer)player);
        }
    }

    public void tickClient(ItemStack stack, EntityPlayer player) {
        String[] tokens;
        if (!Botania.proxy.isTheClientPlayer((EntityLivingBase)player)) {
            return;
        }
        String pos = ItemNBTHelper.getString(stack, TAG_POSITIONS, "");
        for (String token : tokens = pos.split(";")) {
            if (token.isEmpty()) continue;
            if (token.contains(",")) {
                String[] tokens_ = token.split(",");
                int x = Integer.parseInt(tokens_[0]);
                int y = Integer.parseInt(tokens_[1]);
                int z = Integer.parseInt(tokens_[2]);
                float m = 0.02f;
                Botania.proxy.setWispFXDepthTest(false);
                Botania.proxy.wispFX(player.field_70170_p, (float)x + (float)Math.random(), (float)y + (float)Math.random(), (float)z + (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), 0.15f + 0.05f * (float)Math.random(), m * (float)(Math.random() - 0.5), m * (float)(Math.random() - 0.5), m * (float)(Math.random() - 0.5));
                continue;
            }
            int id = Integer.parseInt(token);
            Entity e = player.field_70170_p.func_73045_a(id);
            if (e == null || !(Math.random() < 0.6)) continue;
            Botania.proxy.setWispFXDepthTest(Math.random() < 0.6);
            Botania.proxy.wispFX(player.field_70170_p, e.field_70165_t + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), e.field_70163_u + (double)e.field_70131_O, e.field_70161_v + (double)((float)(Math.random() * 0.5 - 0.25) * 0.45f), (float)Math.random(), (float)Math.random(), (float)Math.random(), 0.15f + 0.05f * (float)Math.random(), -0.05f - 0.03f * (float)Math.random());
        }
        Botania.proxy.setWispFXDepthTest(true);
    }

    public void tickServer(ItemStack stack, EntityPlayer player) {
        StringBuilder positionsBuilder = new StringBuilder();
        this.scanForStack(player.func_184614_ca(), player, positionsBuilder);
        this.scanForStack(player.func_184592_cb(), player, positionsBuilder);
        String current = ItemNBTHelper.getString(stack, TAG_POSITIONS, "");
        String positions = positionsBuilder.toString();
        if (!current.equals(positions)) {
            ItemNBTHelper.setString(stack, TAG_POSITIONS, positions);
            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketSyncBauble(player, 0));
        }
    }

    private void scanForStack(ItemStack pstack, EntityPlayer player, StringBuilder positionsBuilder) {
        if (pstack != null || player.func_70093_af()) {
            int range = 24;
            List entities = player.field_70170_p.func_72872_a(Entity.class, new AxisAlignedBB(player.field_70165_t - (double)range, player.field_70163_u - (double)range, player.field_70161_v - (double)range, player.field_70165_t + (double)range, player.field_70163_u + (double)range, player.field_70161_v + (double)range));
            for (Entity e : entities) {
                if (e == player) continue;
                if (e.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                    if (!this.scanInventory((IItemHandler)e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), pstack)) continue;
                    positionsBuilder.append(e.func_145782_y()).append(";");
                    continue;
                }
                if (e instanceof EntityItem) {
                    EntityItem item = (EntityItem)e;
                    ItemStack istack = item.func_92059_d();
                    if (!player.func_70093_af() && (!istack.func_77969_a(pstack) || !ItemStack.func_77970_a((ItemStack)istack, (ItemStack)pstack))) continue;
                    positionsBuilder.append(item.func_145782_y()).append(";");
                    continue;
                }
                if (e instanceof IInventory) {
                    IInventory inv = (IInventory)e;
                    if (!this.scanInventory((IItemHandler)new InvWrapper(inv), pstack)) continue;
                    positionsBuilder.append(e.func_145782_y()).append(";");
                    continue;
                }
                if (e instanceof EntityHorse) {
                    EntityHorse horse = (EntityHorse)e;
                    AnimalChest chest = (AnimalChest)ReflectionHelper.getPrivateValue(EntityHorse.class, (Object)horse, (String[])LibObfuscation.HORSE_CHEST);
                    if (!this.scanInventory((IItemHandler)new InvWrapper((IInventory)chest), pstack)) continue;
                    positionsBuilder.append(horse.func_145782_y()).append(";");
                    continue;
                }
                if (e instanceof EntityPlayer) {
                    EntityPlayer player_ = (EntityPlayer)e;
                    InvWrapper playerInv = new InvWrapper((IInventory)player_.field_71071_by);
                    InvWrapper binv = new InvWrapper((IInventory)PlayerHandler.getPlayerBaubles((EntityPlayer)player_));
                    if (!this.scanInventory((IItemHandler)playerInv, pstack) && !this.scanInventory((IItemHandler)binv, pstack)) continue;
                    positionsBuilder.append(player_.func_145782_y()).append(";");
                    continue;
                }
                if (e instanceof EntityVillager) {
                    EntityVillager villager = (EntityVillager)e;
                    MerchantRecipeList recipes = villager.func_70934_b(player);
                    if (pstack == null || recipes == null) continue;
                    for (MerchantRecipe recipe : recipes) {
                        if (recipe == null || recipe.func_82784_g() || !this.equalStacks(pstack, recipe.func_77394_a()) && !this.equalStacks(pstack, recipe.func_77397_d())) continue;
                        positionsBuilder.append(villager.func_145782_y()).append(";");
                    }
                    continue;
                }
                if (!(e instanceof EntityLivingBase)) continue;
                EntityLivingBase living = (EntityLivingBase)e;
                ItemStack estack = living.func_184614_ca();
                if (pstack != null && estack != null && this.equalStacks(estack, pstack)) {
                    positionsBuilder.append(living.func_145782_y()).append(";");
                }
                estack = living.func_184592_cb();
                if (pstack == null || estack == null || !this.equalStacks(estack, pstack)) continue;
                positionsBuilder.append(living.func_145782_y()).append(";");
            }
            if (pstack != null) {
                range = 12;
                BlockPos pos = new BlockPos((Entity)player);
                for (int i = -range; i < range + 1; ++i) {
                    for (int j = -range; j < range + 1; ++j) {
                        for (int k = -range; k < range + 1; ++k) {
                            IInventory inv;
                            BlockPos pos_ = pos.func_177982_a(i, j, k);
                            TileEntity tile = player.field_70170_p.func_175625_s(pos_);
                            if (tile == null) continue;
                            boolean foundCap = false;
                            for (EnumFacing e : EnumFacing.field_82609_l) {
                                if (!tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, e) || !this.scanInventory((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, e), pstack)) continue;
                                positionsBuilder.append(pos_.func_177958_n()).append(",").append(pos_.func_177956_o()).append(",").append(pos_.func_177952_p()).append(";");
                                foundCap = true;
                                break;
                            }
                            if (foundCap || !(tile instanceof IInventory) || !this.scanInventory((IItemHandler)new InvWrapper(inv = (IInventory)tile), pstack)) continue;
                            positionsBuilder.append(pos_.func_177958_n()).append(",").append(pos_.func_177956_o()).append(",").append(pos_.func_177952_p()).append(";");
                        }
                    }
                }
            }
        }
    }

    private boolean equalStacks(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    private boolean scanInventory(IItemHandler inv, ItemStack pstack) {
        if (pstack == null) {
            return false;
        }
        for (int l = 0; l < inv.getSlots(); ++l) {
            ItemStack istack = inv.getStackInSlot(l);
            if (istack == null || !this.equalStacks(istack, pstack)) continue;
            return true;
        }
        return false;
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.AMULET;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IBaubleRender.RenderType type, float partialTicks) {
        TextureAtlasSprite gemIcon = MiscellaneousIcons.INSTANCE.itemFinderGem;
        if (type == IBaubleRender.RenderType.HEAD) {
            float f = gemIcon.func_94209_e();
            float f1 = gemIcon.func_94212_f();
            float f2 = gemIcon.func_94206_g();
            float f3 = gemIcon.func_94210_h();
            boolean armor = player.func_184582_a(EntityEquipmentSlot.HEAD) != null;
            IBaubleRender.Helper.translateToHeadLevel(player);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.4f, (float)-1.4f, (float)(armor ? -0.3f : -0.25f));
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, gemIcon.func_94211_a(), gemIcon.func_94216_b(), 0.0625f);
        }
    }
}

