/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import baubles.api.BaubleType;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.subtile.functional.SubTileSolegnolia;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemMagnetRing
extends ItemBauble {
    private static final String TAG_COOLDOWN = "cooldown";
    private static final List<ResourceLocation> BLACKLIST = Arrays.asList(new ResourceLocation("appliedenergistics2", "item.ItemCrystalSeed"));
    final int range;

    public ItemMagnetRing() {
        this("magnetRing", 6);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ItemMagnetRing(String name, int range) {
        super(name);
        this.range = range;
        this.func_185043_a(new ResourceLocation("botania", "on"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return ItemMagnetRing.getCooldown(stack) <= 0 ? 1.0f : 0.0f;
            }
        });
    }

    @SubscribeEvent
    public void onTossItem(ItemTossEvent event) {
        InventoryBaubles inv = PlayerHandler.getPlayerBaubles((EntityPlayer)event.getPlayer());
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemMagnetRing)) continue;
            ItemMagnetRing.setCooldown(stack, 100);
            BotaniaAPI.internalHandler.sendBaubleUpdatePacket(event.getPlayer(), i);
        }
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        super.onWornTick(stack, player);
        int cooldown = ItemMagnetRing.getCooldown(stack);
        if (SubTileSolegnolia.hasSolegnoliaAround((Entity)player)) {
            if (cooldown < 0) {
                ItemMagnetRing.setCooldown(stack, 2);
            }
            return;
        }
        if (cooldown <= 0) {
            if (player.func_70093_af() == ConfigHandler.invertMagnetRing) {
                double x = player.field_70165_t;
                double y = player.field_70163_u + 0.75;
                double z = player.field_70161_v;
                List items = player.field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB(x - (double)this.range, y - (double)this.range, z - (double)this.range, x + (double)this.range, y + (double)this.range, z + (double)this.range));
                int pulled = 0;
                for (EntityItem item : items) {
                    if (!this.canPullItem(item)) continue;
                    if (pulled <= 200) {
                        MathHelper.setEntityMotionFromVector((Entity)item, new Vector3(x, y, z), 0.45f);
                        if (player.field_70170_p.field_72995_K) {
                            boolean red = player.field_70170_p.field_73012_v.nextBoolean();
                            Botania.proxy.sparkleFX(player.field_70170_p, item.field_70165_t, item.field_70163_u, item.field_70161_v, red ? 1.0f : 0.0f, 0.0f, red ? 0.0f : 1.0f, 1.0f, 3);
                        }
                        ++pulled;
                        continue;
                    }
                    break;
                }
            }
        } else {
            ItemMagnetRing.setCooldown(stack, cooldown - 1);
        }
    }

    private boolean canPullItem(EntityItem item) {
        if (item.field_70128_L || SubTileSolegnolia.hasSolegnoliaAround((Entity)item)) {
            return false;
        }
        ItemStack stack = item.func_92059_d();
        if (stack == null || stack.func_77973_b() instanceof IManaItem || stack.func_77973_b() instanceof IRelic || BLACKLIST.contains(field_150901_e.func_177774_c((Object)stack.func_77973_b())) || BotaniaAPI.isItemBlacklistedFromMagnet(stack)) {
            return false;
        }
        BlockPos pos = new BlockPos((Entity)item);
        if (BotaniaAPI.isBlockBlacklistedFromMagnet(item.field_70170_p.func_180495_p(pos))) {
            return false;
        }
        return !BotaniaAPI.isBlockBlacklistedFromMagnet(item.field_70170_p.func_180495_p(pos.func_177977_b()));
    }

    public static int getCooldown(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COOLDOWN, 0);
    }

    public static void setCooldown(ItemStack stack, int cooldown) {
        ItemNBTHelper.setInt(stack, TAG_COOLDOWN, cooldown);
    }

    public static void addItemToBlackList(String item) {
        BLACKLIST.add(new ResourceLocation(item));
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.RING;
    }
}

