/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.bow;

import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.BotaniaCreativeTab;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemLivingwoodBow
extends ItemBow
implements IManaUsingItem {
    private static final Predicate<ItemStack> AMMO_FUNC = s -> s != null && s.func_77973_b() instanceof ItemArrow;
    public static final int MANA_PER_DAMAGE = 40;

    public ItemLivingwoodBow() {
        this("livingwoodBow");
    }

    public ItemLivingwoodBow(String name) {
        this.func_77637_a(BotaniaCreativeTab.INSTANCE);
        GameRegistry.register((IForgeRegistryEntry)this, (ResourceLocation)new ResourceLocation("Botania", name));
        this.func_77655_b(name);
        this.func_77656_e(500);
        this.func_185043_a(new ResourceLocation("minecraft:pull"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack != null && itemstack.func_77973_b() instanceof ItemLivingwoodBow ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) * ItemLivingwoodBow.this.chargeVelocityMultiplier() / 20.0f : 0.0f;
            }
        });
    }

    public String func_77657_g(ItemStack par1ItemStack) {
        return super.func_77657_g(par1ItemStack).replaceAll("item.", "item.botania:");
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        boolean flag = this.canFire(stack, player);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!player.field_71075_bZ.field_75098_d && !flag) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase shooter, int useTicks) {
        boolean infinity;
        int j = (int)((float)(this.func_77626_a(stack) - useTicks) * this.chargeVelocityMultiplier());
        if (shooter instanceof EntityPlayer) {
            ArrowLooseEvent event = new ArrowLooseEvent((EntityPlayer)shooter, stack, world, j, true);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            j = event.getCharge();
        }
        boolean flag = !(shooter instanceof EntityPlayer) || this.canFire(stack, (EntityPlayer)shooter);
        boolean bl = infinity = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        if (flag) {
            int l;
            int k;
            ItemStack ammo;
            float f = (float)j / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            ItemStack itemStack = ammo = shooter instanceof EntityPlayer ? this.getAmmo((EntityPlayer)shooter) : null;
            if (ammo == null || !(ammo.func_77973_b() instanceof ItemArrow)) {
                ammo = new ItemStack(Items.field_151032_g);
            }
            EntityArrow entityarrow = ((ItemArrow)ammo.func_77973_b()).func_185052_a(world, ammo, shooter);
            entityarrow.func_184547_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, f * 3.0f, 1.0f);
            if (f == 1.0f) {
                entityarrow.func_70243_d(true);
            }
            if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)k * 0.5 + 0.5);
            }
            if ((l = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                entityarrow.func_70240_a(l);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                entityarrow.func_70015_d(100);
            }
            ToolCommons.damageItem(stack, 1, shooter, 40);
            world.func_184148_a(null, shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            this.onFire(stack, shooter, infinity, entityarrow);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)entityarrow);
            }
        }
    }

    float chargeVelocityMultiplier() {
        return 1.0f;
    }

    boolean postsEvent() {
        return true;
    }

    boolean canFire(ItemStack stack, EntityPlayer player) {
        return player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0 || PlayerHelper.hasAmmo(player, AMMO_FUNC);
    }

    void onFire(ItemStack bow, EntityLivingBase living, boolean infinity, EntityArrow arrow) {
        if (infinity) {
            arrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
        } else if (living instanceof EntityPlayerMP && ((EntityPlayerMP)living).field_71134_c.func_73081_b().func_77144_e()) {
            PlayerHelper.consumeAmmo((EntityPlayer)((EntityPlayerMP)living), AMMO_FUNC);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        if (!world.field_72995_K && player instanceof EntityPlayer && stack.func_77952_i() > 0 && ManaItemHandler.requestManaExactForTool(stack, (EntityPlayer)player, 80, true)) {
            stack.func_77964_b(stack.func_77952_i() - 1);
        }
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.manaResource && par2ItemStack.func_77952_i() == 3 ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    protected ItemStack getAmmo(EntityPlayer player) {
        return PlayerHelper.getAmmo(player, AMMO_FUNC);
    }
}

