/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.lens.Lens;

public class LensMagnet
extends Lens {
    private static final String TAG_MAGNETIZED = "Botania:Magnetized";
    private static final String TAG_MAGNETIZED_X = "Botania:MagnetizedX";
    private static final String TAG_MAGNETIZED_Y = "Botania:MagnetizedY";
    private static final String TAG_MAGNETIZED_Z = "Botania:MagnetizedZ";

    @Override
    public void updateBurst(IManaBurst burst, EntityThrowable entity, ItemStack stack) {
        BlockPos basePos = new BlockPos((Entity)entity);
        boolean magnetized = entity.getEntityData().func_74764_b(TAG_MAGNETIZED);
        int range = 3;
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)basePos.func_177982_a(-range, -range, -range), (BlockPos)basePos.func_177982_a(range, range, range))) {
            if (!(entity.field_70170_p.func_175625_s(pos) instanceof IManaReceiver)) continue;
            TileEntity tile = entity.field_70170_p.func_175625_s(pos);
            if (magnetized) {
                int magX = entity.getEntityData().func_74762_e(TAG_MAGNETIZED_X);
                int magY = entity.getEntityData().func_74762_e(TAG_MAGNETIZED_Y);
                int magZ = entity.getEntityData().func_74762_e(TAG_MAGNETIZED_Z);
                if (tile.func_174877_v().func_177958_n() != magX || tile.func_174877_v().func_177956_o() != magY || tile.func_174877_v().func_177952_p() != magZ) continue;
            }
            IManaReceiver receiver = (IManaReceiver)tile;
            BlockPos srcCoords = burst.getBurstSourceBlockPos();
            if (!(MathHelper.pointDistanceSpace(tile.func_174877_v(), srcCoords) > 3.0f) || !receiver.canRecieveManaFromBursts() || receiver.isFull()) continue;
            Vector3 burstVec = Vector3.fromEntity((Entity)entity);
            Vector3 tileVec = Vector3.fromTileEntityCenter(tile).add(0.0, -0.1, 0.0);
            Vector3 motionVec = new Vector3(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
            Vector3 normalMotionVec = motionVec.copy().normalize();
            Vector3 magnetVec = tileVec.sub(burstVec).normalize();
            Vector3 differenceVec = normalMotionVec.sub(magnetVec).multiply(motionVec.mag() * 0.1);
            Vector3 finalMotionVec = motionVec.sub(differenceVec);
            if (!magnetized) {
                finalMotionVec.multiply(0.75);
                entity.getEntityData().func_74757_a(TAG_MAGNETIZED, true);
                entity.getEntityData().func_74768_a(TAG_MAGNETIZED_X, tile.func_174877_v().func_177958_n());
                entity.getEntityData().func_74768_a(TAG_MAGNETIZED_Y, tile.func_174877_v().func_177956_o());
                entity.getEntityData().func_74768_a(TAG_MAGNETIZED_Z, tile.func_174877_v().func_177952_p());
            }
            burst.setMotion(finalMotionVec.x, finalMotionVec.y, finalMotionVec.z);
            break;
        }
    }
}

