/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.item.relic.ItemRelic;

public class ItemFlugelEye
extends ItemRelic
implements ICoordBoundItem,
IManaUsingItem {
    private static final String TAG_X = "x";
    private static final String TAG_Y = "y";
    private static final String TAG_Z = "z";
    private static final String TAG_DIMENSION = "dim";

    public ItemFlugelEye() {
        super("flugelEye");
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            if (world.field_72995_K) {
                player.func_184609_a(hand);
                for (int i = 0; i < 10; ++i) {
                    float x1 = (float)((double)pos.func_177958_n() + Math.random());
                    float y1 = pos.func_177956_o() + 1;
                    float z1 = (float)((double)pos.func_177952_p() + Math.random());
                    Botania.proxy.wispFX(player.field_70170_p, x1, y1, z1, (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random() * 0.5f, -0.05f + (float)Math.random() * 0.05f);
                }
            } else {
                ItemNBTHelper.setInt(stack, TAG_X, pos.func_177958_n());
                ItemNBTHelper.setInt(stack, TAG_Y, pos.func_177956_o());
                ItemNBTHelper.setInt(stack, TAG_Z, pos.func_177952_p());
                ItemNBTHelper.setInt(stack, TAG_DIMENSION, world.field_73011_w.getDimension());
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 5.0f);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        float x = (float)(living.field_70165_t - Math.random() * (double)living.field_70130_N);
        float y = (float)(living.field_70163_u - 1.6 + Math.random());
        float z = (float)(living.field_70161_v - Math.random() * (double)living.field_70130_N);
        Botania.proxy.wispFX(living.field_70170_p, x, y, z, (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random() * 0.7f, -0.05f - (float)Math.random() * 0.05f);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, EnumHand hand) {
        par3EntityPlayer.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)par1ItemStack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase living) {
        if (!(living instanceof EntityPlayer)) {
            return stack;
        }
        EntityPlayer player = (EntityPlayer)living;
        int x = ItemNBTHelper.getInt(stack, TAG_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_Y, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_Z, 0);
        int dim = ItemNBTHelper.getInt(stack, TAG_DIMENSION, 0);
        int cost = (int)(MathHelper.pointDistanceSpace((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, player.field_70165_t, player.field_70163_u, player.field_70161_v) * 10.0f);
        if (y > -1 && dim == world.field_73011_w.getDimension() && ManaItemHandler.requestManaExact(stack, player, cost, true)) {
            ItemFlugelEye.moveParticlesAndSound((Entity)player);
            if (player instanceof EntityPlayerMP && !world.field_72995_K) {
                ((EntityPlayerMP)player).field_71135_a.func_147364_a((double)x + 0.5, (double)y + 1.6, (double)z + 0.5, player.field_70177_z, player.field_70125_A);
            }
            ItemFlugelEye.moveParticlesAndSound((Entity)player);
        }
        return stack;
    }

    private static void moveParticlesAndSound(Entity entity) {
        for (int i = 0; i < 15; ++i) {
            float x = (float)(entity.field_70165_t + Math.random());
            float y = (float)(entity.field_70163_u - 1.6 + Math.random());
            float z = (float)(entity.field_70161_v + Math.random());
            Botania.proxy.wispFX(entity.field_70170_p, x, y, z, (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), -0.3f + (float)Math.random() * 0.2f);
        }
        if (!entity.field_70170_p.field_72995_K) {
            entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 40;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BLOCK;
    }

    @Override
    public BlockPos getBinding(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_Y, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_Z, 0);
        return y == -1 ? null : new BlockPos(x, y, z);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }
}

