/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.sound.BotaniaSoundEvents;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileBifrost;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ItemMod;

public class ItemRainbowRod
extends ItemMod
implements IManaUsingItem,
IAvatarWieldable {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatarRainbow.png");
    private static final int MANA_COST = 750;
    private static final int MANA_COST_AVATAR = 10;
    private static final int TIME = 600;

    public ItemRainbowRod() {
        super("rainbowRod");
        this.func_77656_e(600);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, EnumHand hand) {
        if (!par2World.field_72995_K && par1ItemStack.func_77952_i() == 0 && ManaItemHandler.requestManaExactForTool(par1ItemStack, par3EntityPlayer, 750, false)) {
            int count;
            Block place = ModBlocks.bifrost;
            Vector3 vector = new Vector3(par3EntityPlayer.func_70040_Z()).normalize();
            double x = par3EntityPlayer.field_70165_t;
            double y = par3EntityPlayer.field_70163_u;
            double z = par3EntityPlayer.field_70161_v;
            double lx = 0.0;
            double ly = -1.0;
            double lz = 0.0;
            boolean prof = IManaProficiencyArmor.Helper.hasProficiency(par3EntityPlayer);
            int maxlen = prof ? 160 : 100;
            int time = prof ? 960 : 600;
            BlockPos playerPos = new BlockPos((int)x, (int)y, (int)z);
            for (count = 0; (count < maxlen && (int)lx == (int)x && (int)ly == (int)y && (int)lz == (int)z || count < 4 || par2World.func_180495_p(playerPos).func_177230_c().isAir(par2World.func_180495_p(playerPos), (IBlockAccess)par2World, playerPos) || par2World.func_180495_p(playerPos).func_177230_c() == place) && !(y >= 256.0) && !(y <= 0.0); ++count) {
                for (int i = -2; i < 1; ++i) {
                    for (int j = -2; j < 1; ++j) {
                        BlockPos pos_ = new BlockPos((int)x + i, (int)y, (int)z + j);
                        if (!par2World.func_180495_p(pos_).func_177230_c().isAir(par2World.func_180495_p(pos_), (IBlockAccess)par2World, pos_) && par2World.func_180495_p(pos_).func_177230_c() != place) continue;
                        par2World.func_175656_a(pos_, place.func_176223_P());
                        TileBifrost tile = (TileBifrost)par2World.func_175625_s(pos_);
                        if (tile == null) continue;
                        for (int k = 0; k < 4; ++k) {
                            Botania.proxy.sparkleFX(par2World, (double)tile.func_174877_v().func_177958_n() + Math.random(), (double)tile.func_174877_v().func_177956_o() + Math.random(), (double)tile.func_174877_v().func_177952_p() + Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), 0.45f + 0.2f * (float)Math.random(), 6);
                        }
                        tile.ticks = time;
                    }
                }
                lx = x;
                ly = y;
                lz = z;
                x += vector.x;
                y += vector.y;
                z += vector.z;
            }
            if (count > 0) {
                par2World.func_184148_a(null, par3EntityPlayer.field_70165_t, par3EntityPlayer.field_70163_u, par3EntityPlayer.field_70161_v, BotaniaSoundEvents.bifrostRod, SoundCategory.PLAYERS, 0.5f, 0.25f);
                ManaItemHandler.requestManaExactForTool(par1ItemStack, par3EntityPlayer, 750, false);
                par1ItemStack.func_77964_b(600);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)par1ItemStack);
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack.func_77946_l();
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.getContainerItem(stack) != null;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (par1ItemStack.func_77951_h()) {
            par1ItemStack.func_77964_b(par1ItemStack.func_77952_i() - 1);
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public void onAvatarUpdate(IAvatarTile tile, ItemStack stack) {
        TileEntity te = (TileEntity)tile;
        World world = te.func_145831_w();
        if (world.field_72995_K || tile.getCurrentMana() < 250 || !tile.isEnabled()) {
            return;
        }
        BlockPos tePos = te.func_174877_v();
        int w = 1;
        int h = 1;
        int l = 20;
        AxisAlignedBB axis = null;
        switch ((EnumFacing)world.func_180495_p(tePos).func_177229_b(BotaniaStateProps.CARDINALS)) {
            case NORTH: {
                axis = new AxisAlignedBB(tePos.func_177982_a(-w, -h, -l), tePos.func_177982_a(w + 1, h, 0));
                break;
            }
            case SOUTH: {
                axis = new AxisAlignedBB(tePos.func_177982_a(-w, -h, 1), tePos.func_177982_a(w + 1, h, l + 1));
                break;
            }
            case WEST: {
                axis = new AxisAlignedBB(tePos.func_177982_a(-l, -h, -w), tePos.func_177982_a(0, h, w + 1));
                break;
            }
            case EAST: {
                axis = new AxisAlignedBB(tePos.func_177982_a(1, -h, -w), tePos.func_177982_a(l + 1, h, w + 1));
            }
        }
        List players = world.func_72872_a(EntityPlayer.class, axis);
        for (EntityPlayer p : players) {
            int px = MathHelper.func_76128_c((double)p.field_70165_t);
            int py = MathHelper.func_76128_c((double)p.field_70163_u) - 1;
            int pz = MathHelper.func_76128_c((double)p.field_70161_v);
            int dist = 5;
            int diff = dist / 2;
            for (int i = 0; i < dist; ++i) {
                for (int j = 0; j < dist; ++j) {
                    TileBifrost tileBifrost;
                    int ex = px + i - diff;
                    int ez = pz + j - diff;
                    if (!axis.func_72318_a(new Vec3d((double)ex + 0.5, (double)(py + 1), (double)ez + 0.5))) continue;
                    BlockPos pos = new BlockPos(ex, py, ez);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (block.isAir(world.func_180495_p(pos), (IBlockAccess)world, pos)) {
                        world.func_175656_a(pos, ModBlocks.bifrost.func_176223_P());
                        tileBifrost = (TileBifrost)world.func_175625_s(pos);
                        tileBifrost.ticks = 10;
                        tile.recieveMana(-10);
                        continue;
                    }
                    if (block != ModBlocks.bifrost) continue;
                    tileBifrost = (TileBifrost)world.func_175625_s(pos);
                    if (tileBifrost.ticks >= 2) continue;
                    tileBifrost.ticks = 10;
                    tile.recieveMana(-10);
                }
            }
        }
    }

    @Override
    public ResourceLocation getOverlayResource(IAvatarTile tile, ItemStack stack) {
        return avatarOverlay;
    }
}

