/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.IItemRenderer;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.BuiltInModel;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ModelRegistryHelper {
    private static List<Pair<ModelResourceLocation, IBakedModel>> registerModels = new LinkedList<Pair<ModelResourceLocation, IBakedModel>>();

    public static void register(ModelResourceLocation location, IBakedModel model) {
        registerModels.add((Pair<ModelResourceLocation, IBakedModel>)new ImmutablePair((Object)location, (Object)model));
    }

    public static void registerItemRenderer(Item item, IItemRenderer renderer) {
        final ModelResourceLocation modelLoc = new ModelResourceLocation((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item), "inventory");
        ModelRegistryHelper.register(modelLoc, renderer);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return modelLoc;
            }
        });
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        for (Pair<ModelResourceLocation, IBakedModel> pair : registerModels) {
            event.getModelRegistry().func_82595_a(pair.getKey(), pair.getValue());
        }
    }

    public static void setParticleTexture(Block block, final ResourceLocation tex) {
        final ModelResourceLocation modelLoc = new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block), "particle");
        ModelRegistryHelper.register(modelLoc, (IBakedModel)new BuiltInModel(BlockRenderer.blockCameraTransform, ItemOverrideList.field_188022_a){

            public TextureAtlasSprite func_177554_e() {
                return Minecraft.func_71410_x().func_147117_R().func_110572_b(tex.toString());
            }
        });
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new IStateMapper(){

            public Map<IBlockState, ModelResourceLocation> func_178130_a(Block blockIn) {
                return Maps.toMap((Iterable)blockIn.func_176194_O().func_177619_a(), (Function)new Function<IBlockState, ModelResourceLocation>(){

                    public ModelResourceLocation apply(IBlockState input) {
                        return modelLoc;
                    }
                });
            }
        });
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new ModelRegistryHelper());
    }
}

