/*
 * Decompiled with CFR 0.152.
 */
package techreborn.manual.designer.fileUtils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.scene.control.TreeItem;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import techreborn.manual.designer.ManualDesigner;
import techreborn.manual.saveFormat.Entry;
import techreborn.manual.saveFormat.ManualFormat;

public class SaveSystem {
    public static HashMap<TreeItem, Entry> entries = new HashMap();
    public static ManualFormat master;
    public static File lastSave;

    public static void export() {
        File masterJson;
        File selectedDirectory;
        ArrayList<Entry> entryList = new ArrayList<Entry>(entries.values());
        if (master == null) {
            master = new ManualFormat("TechReborn", "techreborn", entryList);
        }
        DirectoryChooser chooser = new DirectoryChooser();
        chooser.setTitle("Select export location");
        File openLocation = new File(".");
        if (lastSave != null) {
            openLocation = lastSave;
        }
        chooser.setInitialDirectory(openLocation);
        lastSave = selectedDirectory = chooser.showDialog((Window)ManualDesigner.stage);
        File imageDir = new File(selectedDirectory, "images");
        if (!imageDir.exists()) {
            imageDir.mkdir();
        }
        if ((masterJson = new File(selectedDirectory, "master.json")).exists()) {
            masterJson.delete();
        }
        if (selectedDirectory != null) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(master);
            try {
                FileWriter writer = new FileWriter(masterJson);
                writer.write(json);
                writer.close();
            }
            catch (IOException e) {
                System.out.println("something bad happened");
                e.printStackTrace();
            }
        }
    }

    static {
        lastSave = null;
    }
}

