/*
 * Decompiled with CFR 0.152.
 */
package techreborn.manual.designer.windows;

import java.awt.Toolkit;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuBar;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import techreborn.manual.designer.ManualCatergories;
import techreborn.manual.designer.fileUtils.LoadSystem;
import techreborn.manual.designer.fileUtils.SaveSystem;
import techreborn.manual.saveFormat.Entry;
import techreborn.manual.saveFormat.EntryData;

public class MainWindowController {
    public MenuBar menuBar;
    public SplitPane splitPane;
    public TreeView treeList;
    public ImageView image;
    public AnchorPane renderPane;
    public Button buttonNew;
    public TextArea textInput;
    public Button buttonDelete;
    public TextField nameTextArea;
    public TextField imageTextArea;
    public ImageView pageimage;
    public Label infoLabel;

    public void newItem(Event event) {
        if (this.treeList.getSelectionModel().getSelectedItem() instanceof TreeItem) {
            TreeItem item = (TreeItem)this.treeList.getSelectionModel().getSelectedItem();
            if (item == ManualCatergories.blocks || item == ManualCatergories.items) {
                TextInputDialog dialog = new TextInputDialog("");
                dialog.setTitle("Name?");
                dialog.setContentText("Name of item:");
                Optional result = dialog.showAndWait();
                if (result.isPresent() && !((String)result.get()).isEmpty()) {
                    TreeItem newItem = new TreeItem(result.get());
                    Entry entry = new Entry();
                    entry.name = (String)result.get();
                    ArrayList<String> choices = new ArrayList<String>();
                    choices.add("Text");
                    choices.add("Image");
                    ChoiceDialog choiceDialog = new ChoiceDialog((Object)"Text", choices);
                    choiceDialog.setTitle("Type?");
                    Optional choiceResult = choiceDialog.showAndWait();
                    if (!choiceResult.isPresent()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    System.out.println((String)choiceResult.get());
                    entry.type = (String)choiceResult.get();
                    entry.category = (String)item.getValue();
                    item.getChildren().add((Object)newItem);
                    item.setExpanded(true);
                    SaveSystem.entries.put(newItem, entry);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public void deleteItem(Event event) {
        TreeItem item;
        TreeItem parent;
        if (this.treeList.getSelectionModel().getSelectedItem() instanceof TreeItem && (parent = (item = (TreeItem)this.treeList.getSelectionModel().getSelectedItem()).getParent()) != null) {
            if (parent == ManualCatergories.blocks || parent == ManualCatergories.items) {
                parent.getChildren().remove((Object)item);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public void save(ActionEvent actionEvent) {
        SaveSystem.export();
    }

    public void open(ActionEvent actionEvent) {
        try {
            LoadSystem.load();
        }
        catch (FileNotFoundException e) {
            System.out.println("bad things happened");
            e.printStackTrace();
        }
    }

    public void close(ActionEvent actionEvent) {
        System.exit(0);
    }

    public void load() {
        this.textInput.textProperty().addListener((observable, oldValue, newValue) -> this.textAreaChanged());
        this.nameTextArea.textProperty().addListener((observable, oldValue, newValue) -> this.nameChange());
        this.imageTextArea.textProperty().addListener((observable, oldValue, newValue) -> this.imageAreaChanged());
    }

    public void textAreaChanged() {
        if (!this.treeList.getSelectionModel().isEmpty() && SaveSystem.entries.containsKey(this.treeList.getSelectionModel().getSelectedItem())) {
            Entry entry = SaveSystem.entries.get(this.treeList.getSelectionModel().getSelectedItem());
            if (entry != null) {
                if (entry.data == null) {
                    entry.data = new EntryData();
                }
                if (entry.data.data == null) {
                    entry.data.data = new HashMap();
                }
                if (entry.data.data.containsKey("text")) {
                    entry.data.data.replace("text", this.textInput.getText());
                } else {
                    entry.data.data.put("text", this.textInput.getText());
                }
            }
            SaveSystem.entries.replace((TreeItem)this.treeList.getSelectionModel().getSelectedItem(), entry);
        }
    }

    public void imageAreaChanged() {
        if (!this.treeList.getSelectionModel().isEmpty() && SaveSystem.entries.containsKey(this.treeList.getSelectionModel().getSelectedItem())) {
            Entry entry = SaveSystem.entries.get(this.treeList.getSelectionModel().getSelectedItem());
            if (entry != null) {
                if (entry.data == null) {
                    entry.data = new EntryData();
                }
                if (entry.data.data == null) {
                    entry.data.data = new HashMap();
                }
                if (entry.data.data.containsKey("image")) {
                    entry.data.data.replace("image", this.imageTextArea.getText());
                } else {
                    entry.data.data.put("image", this.imageTextArea.getText());
                }
            }
            SaveSystem.entries.replace((TreeItem)this.treeList.getSelectionModel().getSelectedItem(), entry);
        }
    }

    public void nameChange() {
        Entry entry;
        if (!this.treeList.getSelectionModel().isEmpty() && SaveSystem.entries.containsKey(this.treeList.getSelectionModel().getSelectedItem()) && (entry = SaveSystem.entries.get(this.treeList.getSelectionModel().getSelectedItem())) != null) {
            entry.registryName = this.nameTextArea.getText();
            SaveSystem.entries.replace((TreeItem)this.treeList.getSelectionModel().getSelectedItem(), entry);
        }
    }
}

