/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import team.chisel.common.block.BlockCarvable;

public enum EnumConnection {
    DOWN(EnumConnection.pos().func_177977_b()),
    UP(EnumConnection.pos().func_177984_a()),
    NORTH(EnumConnection.pos().func_177978_c()),
    SOUTH(EnumConnection.pos().func_177968_d()),
    EAST(EnumConnection.pos().func_177974_f()),
    WEST(EnumConnection.pos().func_177976_e()),
    NORTH_EAST(EnumConnection.pos().func_177978_c().func_177974_f()),
    NORTH_WEST(EnumConnection.pos().func_177978_c().func_177976_e()),
    NORTH_UP(EnumConnection.pos().func_177978_c().func_177984_a()),
    NORTH_DOWN(EnumConnection.pos().func_177978_c().func_177977_b()),
    SOUTH_EAST(EnumConnection.pos().func_177968_d().func_177974_f()),
    SOUTH_WEST(EnumConnection.pos().func_177968_d().func_177976_e()),
    SOUTH_UP(EnumConnection.pos().func_177968_d().func_177984_a()),
    SOUTH_DOWN(EnumConnection.pos().func_177968_d().func_177977_b()),
    EAST_UP(EnumConnection.pos().func_177974_f().func_177984_a()),
    EAST_DOWN(EnumConnection.pos().func_177974_f().func_177977_b()),
    WEST_UP(EnumConnection.pos().func_177976_e().func_177984_a()),
    WEST_DOWN(EnumConnection.pos().func_177976_e().func_177977_b());

    public static final EnumConnection[] VALUES;
    private static final Map<BlockPos, EnumConnection> vecMap;
    private BlockPos positionVector;

    private EnumConnection(BlockPos positionVector) {
        this.positionVector = positionVector;
    }

    private static BlockPos pos() {
        return new BlockPos(0, 0, 0);
    }

    public static EnumConnection fromFacings(EnumFacing ... facings) {
        BlockPos vec = EnumConnection.pos();
        for (EnumFacing f : facings) {
            vec = vec.func_177972_a(f);
        }
        return EnumConnection.fromVec(vec);
    }

    public static EnumConnection fromVec(BlockPos vec) {
        EnumConnection ret = vecMap.get(vec);
        if (ret == null) {
            for (EnumConnection c : VALUES) {
                if (!c.positionVector.equals((Object)vec)) continue;
                vecMap.put(vec, c);
                ret = c;
            }
        }
        return ret;
    }

    public boolean isValid(BlockPos origin, IBlockAccess w) {
        if (w.func_180495_p(origin).func_177230_c() instanceof BlockCarvable) {
            return w.func_180495_p(origin).equals(w.func_180495_p(origin.func_177971_a((Vec3i)this.positionVector)));
        }
        return false;
    }

    static {
        VALUES = EnumConnection.values();
        vecMap = Maps.newHashMap();
    }
}

