/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util.json;

import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import team.chisel.api.render.IChiselFace;
import team.chisel.api.render.IChiselTexture;
import team.chisel.client.ChiselFace;
import team.chisel.common.util.json.JsonHelper;
import team.chisel.common.util.json.JsonObjectBase;

public class JsonFace
extends JsonObjectBase<IChiselFace> {
    private String[] textures;
    private String particle;

    @Override
    protected IChiselFace create(ResourceLocation loc) {
        Preconditions.checkNotNull((Object)this.textures, (Object)".cf files must have a textures field!");
        ChiselFace face = new ChiselFace(loc);
        for (String child : this.textures) {
            ResourceLocation childLoc;
            if (JsonHelper.isLocalPath(child)) {
                child = JsonHelper.toAbsolutePath(child, loc);
            }
            if (JsonHelper.isFace(childLoc = new ResourceLocation(child))) {
                face.addChildFace(JsonHelper.getOrCreateFace(childLoc));
                continue;
            }
            if (JsonHelper.isTex(childLoc)) {
                face.addTexture(JsonHelper.getOrCreateTexture(childLoc));
                continue;
            }
            if (JsonHelper.isValidFace(childLoc)) {
                face.addChildFace(JsonHelper.getOrCreateFace(childLoc));
                continue;
            }
            face.addTexture(JsonHelper.getOrCreateTexture(childLoc));
        }
        if (this.particle != null) {
            if (JsonHelper.isLocalPath(this.particle)) {
                this.particle = JsonHelper.toAbsolutePath(this.particle, loc);
            }
            face.setParticle(JsonHelper.getOrCreateTexture(new ResourceLocation(this.particle)).getParticle());
        }
        if (loc.func_110623_a().contains("animated")) {
            System.out.println("test");
        }
        face.setLayer(this.getLayer(face.getTextureList()));
        return face;
    }

    private BlockRenderLayer getLayer(List<IChiselTexture<?>> list) {
        BlockRenderLayer layer = BlockRenderLayer.SOLID;
        for (IChiselTexture<?> tex : list) {
            BlockRenderLayer texLayer = tex.getLayer();
            if (texLayer.ordinal() <= layer.ordinal()) continue;
            layer = texLayer;
        }
        return layer;
    }
}

