/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util.json;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import team.chisel.api.render.IBlockRenderType;
import team.chisel.api.render.IChiselTexture;
import team.chisel.api.render.TextureInfo;
import team.chisel.api.render.TextureSpriteCallback;
import team.chisel.client.TextureStitcher;
import team.chisel.common.init.TextureTypeRegistry;
import team.chisel.common.util.json.JsonHelper;
import team.chisel.common.util.json.JsonObjectBase;

public class JsonTexture
extends JsonObjectBase<IChiselTexture<?>> {
    private String type;
    private String[] textures;
    @Nullable
    private String layer;
    @Nullable
    private JsonObject info;
    private boolean fullbright;

    @Override
    protected IChiselTexture<?> create(ResourceLocation loc) {
        Preconditions.checkArgument((boolean)TextureTypeRegistry.isValid(this.type), (String)("Error loading texture %s. Texture Type " + this.type + " is not valid"), (Object[])new Object[]{loc});
        IBlockRenderType type = TextureTypeRegistry.getType(this.type);
        Preconditions.checkArgument((this.textures != null || type.requiredTextures() == 1 ? 1 : 0) != 0, (String)"Error loading texture %s. Texture type %s requires %s textures, the texture name can only be inferred for textures that require 1.", (Object[])new Object[]{loc, this.type, type.requiredTextures()});
        if (this.textures != null) {
            Preconditions.checkArgument((this.textures.length == type.requiredTextures() ? 1 : 0) != 0, (String)"Error loading texture %s. Texture type %s requires exactly %s textures. %s were provided.", (Object[])new Object[]{loc, this.type, type.requiredTextures(), this.textures.length});
        }
        TextureSpriteCallback[] callbacks = new TextureSpriteCallback[type.requiredTextures()];
        if (this.textures == null) {
            callbacks[0] = new TextureSpriteCallback(new ResourceLocation(loc.func_110624_b(), JsonHelper.toTexturePath(loc.func_110623_a())));
            TextureStitcher.register(callbacks[0]);
        } else {
            for (int i = 0; i < this.textures.length; ++i) {
                String tex = this.textures[i];
                if (JsonHelper.isLocalPath(tex)) {
                    String path = JsonHelper.toAbsolutePath(tex, loc);
                    path = path.substring(path.indexOf(58) + 1);
                    tex = JsonHelper.toTexturePath(path);
                }
                callbacks[i] = new TextureSpriteCallback(new ResourceLocation(loc.func_110624_b(), tex));
                TextureStitcher.register(callbacks[i]);
            }
        }
        if (loc.func_110623_a().contains("animated")) {
            System.out.println("test");
        }
        BlockRenderLayer layerObj = this.layer == null ? BlockRenderLayer.SOLID : BlockRenderLayer.valueOf((String)this.layer.toUpperCase(Locale.US));
        TextureInfo textureInfo = this.info != null ? new TextureInfo(callbacks, Optional.of(this.info), layerObj, this.fullbright) : new TextureInfo(callbacks, Optional.empty(), layerObj, this.fullbright);
        try {
            return type.makeTexture(textureInfo);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed loading texture " + loc, e);
        }
    }
}

