/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.texture;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import team.chisel.api.render.IBlockRenderContext;
import team.chisel.api.render.TextureInfo;
import team.chisel.client.render.Quad;
import team.chisel.client.render.ctm.Submap;
import team.chisel.client.render.ctx.BlockRenderContextPosition;
import team.chisel.client.render.texture.AbstractChiselTexture;
import team.chisel.client.render.type.BlockRenderTypeMap;

public class ChiselTextureMap
extends AbstractChiselTexture<BlockRenderTypeMap> {
    private final int xSize;
    private final int ySize;
    private final MapType map;
    private static final Random rand = new Random();

    public ChiselTextureMap(BlockRenderTypeMap type, TextureInfo info, MapType map) {
        super(type, info);
        this.map = map;
        if (this.info.isPresent()) {
            JsonObject object = (JsonObject)this.info.get();
            if (object.has("width") && object.has("height")) {
                Preconditions.checkArgument((object.get("width").isJsonPrimitive() && object.get("width").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"width must be a number!");
                Preconditions.checkArgument((object.get("height").isJsonPrimitive() && object.get("height").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"height must be a number!");
                this.xSize = object.get("width").getAsInt();
                this.ySize = object.get("height").getAsInt();
            } else if (object.has("size")) {
                Preconditions.checkArgument((object.get("size").isJsonPrimitive() && object.get("size").getAsJsonPrimitive().isNumber() ? 1 : 0) != 0, (Object)"size must be a number!");
                this.xSize = object.get("size").getAsInt();
                this.ySize = object.get("size").getAsInt();
            } else {
                this.ySize = 2;
                this.xSize = 2;
            }
        } else {
            this.ySize = 2;
            this.xSize = 2;
        }
        Preconditions.checkArgument((this.xSize > 0 && this.ySize > 0 ? 1 : 0) != 0, (Object)"Cannot have a dimension of 0!");
    }

    @Override
    public List<BakedQuad> transformQuad(BakedQuad quad, IBlockRenderContext context, int quadGoal) {
        return this.map.transformQuad(this, quad, context, quadGoal);
    }

    public static enum MapType {
        RANDOM{

            @Override
            protected List<BakedQuad> transformQuad(ChiselTextureMap tex, BakedQuad quad, IBlockRenderContext context, int quadGoal) {
                EnumFacing side = quad.func_178210_d();
                BlockPos pos = context == null ? new BlockPos(0, 0, 0) : ((BlockRenderContextPosition)context).getPosition();
                rand.setSeed(MathHelper.func_180186_a((Vec3i)pos) + (long)side.ordinal());
                rand.nextBoolean();
                int w = tex.xSize;
                int h = tex.ySize;
                float intervalX = 16.0f / (float)w;
                float intervalY = 16.0f / (float)h;
                int unitsAcross = rand.nextInt(w) + 1;
                int unitsDown = rand.nextInt(h) + 1;
                float maxU = (float)unitsAcross * intervalX;
                float maxV = (float)unitsDown * intervalY;
                Submap uvs = new Submap(intervalX, intervalY, maxU - intervalX, maxV - intervalY);
                return Collections.singletonList(Quad.from(quad).transformUVs(tex.sprites[0].getSprite(), uvs).setFullbright(tex.fullbright).rebake());
            }
        }
        ,
        PATTERNED{

            @Override
            protected List<BakedQuad> transformQuad(ChiselTextureMap tex, BakedQuad quad, IBlockRenderContext context, int quadGoal) {
                int ty;
                int tx;
                EnumFacing side = quad.func_178210_d();
                BlockPos pos = context == null ? new BlockPos(0, 0, 0) : ((BlockRenderContextPosition)context).getPosition();
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                if (side.func_176740_k().func_176720_b()) {
                    tx = x % tex.xSize;
                    ty = z % tex.ySize;
                } else if (side.func_176740_k() == EnumFacing.Axis.Z) {
                    tx = x % tex.xSize;
                    ty = -y % tex.ySize;
                } else {
                    tx = z % tex.xSize;
                    ty = -y % tex.ySize;
                }
                if (side == EnumFacing.NORTH || side == EnumFacing.EAST) {
                    tx = (tex.xSize - tx - 1) % tex.xSize;
                }
                if (tx < 0) {
                    tx += tex.xSize;
                }
                if (ty < 0) {
                    ty += tex.ySize;
                }
                float intervalU = 16.0f / (float)tex.xSize;
                float intervalV = 16.0f / (float)tex.ySize;
                float minU = intervalU * (float)tx;
                float minV = intervalV * (float)ty;
                Submap submap = new Submap(intervalU, intervalV, minU, minV);
                Quad q = Quad.from(quad).setFullbright(tex.fullbright);
                if (quadGoal != 4) {
                    return Collections.singletonList(q.transformUVs(tex.sprites[0].getSprite(), submap).rebake());
                }
                Quad[] quads = q.subdivide(4);
                for (int i = 0; i < quads.length; ++i) {
                    if (quads[i] == null) continue;
                    quads[i] = quads[i].transformUVs(tex.sprites[0].getSprite(), submap);
                }
                return Arrays.stream(quads).filter(Objects::nonNull).map(Quad::rebake).collect(Collectors.toList());
            }
        };


        protected abstract List<BakedQuad> transformQuad(ChiselTextureMap var1, BakedQuad var2, IBlockRenderContext var3, int var4);
    }
}

