/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import gnu.trove.set.TLongSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.api.block.ICarvable;
import team.chisel.api.render.IBlockRenderType;
import team.chisel.api.render.IChiselFace;
import team.chisel.api.render.IChiselTexture;
import team.chisel.api.render.RenderContextList;
import team.chisel.client.render.ModelChisel;
import team.chisel.common.block.BlockCarvable;

public class ModelChiselBlock
implements IPerspectiveAwareModel {
    private List<BakedQuad> face;
    private List<BakedQuad> general;
    private ModelChisel model;
    private Overrides overrides = new Overrides();
    private static Cache<Pair<IBlockState, TLongSet>, ModelChiselBlock> modelcache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(500L).build();
    private static final Map<ItemCameraTransforms.TransformType, TRSRTransformation> TRANSFORMS = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ModelChiselBlock.get(0.0f, 0.0f, 0.0f, 30.0f, 45.0f, 0.0f, 0.625f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ModelChiselBlock.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ModelChiselBlock.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ModelChiselBlock.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ModelChiselBlock.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ModelChiselBlock.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f)).build();
    private static final TRSRTransformation DEFAULT_TRANSFORM = ModelChiselBlock.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);

    public ModelChiselBlock(List<BakedQuad> face, List<BakedQuad> general, ModelChisel model) {
        this.face = face;
        this.general = general;
        this.model = model;
    }

    public ModelChiselBlock(ModelChisel model) {
        this(Collections.emptyList(), Collections.emptyList(), model);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        ModelChiselBlock baked;
        if (state != null && state.func_177230_c() instanceof ICarvable && state instanceof IExtendedBlockState) {
            IExtendedBlockState ext = (IExtendedBlockState)state;
            IBlockState clean = ext.getClean();
            RenderContextList ctxList = (RenderContextList)ext.getValue((IUnlistedProperty)BlockCarvable.CTX_LIST);
            if (ctxList == null) {
                baked = (ModelChiselBlock)modelcache.get((Object)Pair.of((Object)clean, null), () -> this.createModel(state, this.model, null));
            } else {
                TLongSet serialized = ctxList.serialized();
                baked = (ModelChiselBlock)modelcache.get((Object)Pair.of((Object)clean, (Object)serialized), () -> this.createModel((IBlockState)ext, this.model, ctxList));
            }
        } else {
            baked = this;
        }
        return side == null ? baked.general : FluentIterable.from(baked.face).filter(quad -> quad.func_178210_d() == side).toList();
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.model.getDefaultFace().getParticle();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    private ModelChiselBlock createModel(IBlockState state, ModelChisel model, RenderContextList ctx) {
        ArrayList faceQuads = Lists.newArrayList();
        ArrayList generalQuads = Lists.newArrayList();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IChiselFace face = model.getFace(facing);
            if (ctx != null && MinecraftForgeClient.getRenderLayer() != face.getLayer()) continue;
            int quadGoal = ctx == null ? 1 : (Integer)Ordering.natural().max((Iterable)FluentIterable.from(face.getTextureList()).transform(tex -> tex.getType().getQuadsPerSide()));
            IBakedModel baked = model.getModel(state);
            List origFaceQuads = baked.func_188616_a(state, facing, 0L);
            ImmutableList origGeneralQuads = FluentIterable.from((Iterable)baked.func_188616_a(state, null, 0L)).filter(q -> q.func_178210_d() == facing).toList();
            this.addAllQuads(origFaceQuads, face, ctx, quadGoal, faceQuads);
            this.addAllQuads((List<BakedQuad>)origGeneralQuads, face, ctx, quadGoal, generalQuads);
        }
        return new ModelChiselBlock(faceQuads, generalQuads, model);
    }

    private void addAllQuads(List<BakedQuad> from, IChiselFace face, @Nullable RenderContextList ctx, int quadGoal, List<BakedQuad> to) {
        for (BakedQuad q : from) {
            for (IChiselTexture<?> tex : face.getTextureList()) {
                to.addAll(tex.transformQuad(q, ctx == null ? null : ctx.getRenderContext((IBlockRenderType)tex.getType()), quadGoal));
            }
        }
    }

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }

    public Pair<? extends IPerspectiveAwareModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)TRANSFORMS.getOrDefault(cameraTransformType, DEFAULT_TRANSFORM).getMatrix());
    }

    private class Overrides
    extends ItemOverrideList {
        public Overrides() {
            super((List)Lists.newArrayList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            return ModelChiselBlock.this.createModel(block.func_176223_P(), ModelChiselBlock.this.model, null);
        }
    }
}

