/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.chisel.Chisel;
import team.chisel.api.block.ICarvable;
import team.chisel.api.block.VariationData;
import team.chisel.api.render.RenderContextList;
import team.chisel.client.BlockFaceData;
import team.chisel.client.ClientUtil;
import team.chisel.common.block.BlockCarvable;
import team.chisel.common.init.ChiselTabs;
import team.chisel.common.init.TextureTypeRegistry;
import team.chisel.common.util.PropertyAnyInteger;

public class BlockCarvablePane
extends BlockPane
implements ICarvable {
    private final PropertyAnyInteger metaProp;
    @SideOnly(value=Side.CLIENT)
    private BlockFaceData blockFaceData;
    private final VariationData[] variations;
    private int index;
    private final int maxVariation;
    private final BlockStateContainer realBlockState;

    public BlockCarvablePane(Material material, boolean canDrop, int index, int max, VariationData ... variations) {
        super(material, canDrop);
        this.func_149647_a(ChiselTabs.tab);
        this.index = index;
        this.variations = variations;
        this.maxVariation = max;
        this.metaProp = PropertyAnyInteger.create("variation", 0, max > index * 16 ? 15 : max % 16);
        this.realBlockState = this.createRealBlockState();
        this.setupStates();
        Chisel.proxy.initiateFaceData(this);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176194_O().func_177621_b().func_177226_a((IProperty)this.metaProp, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.metaProp);
    }

    public String getIndexName() {
        if (this.index == 0) {
            return this.func_149739_a();
        }
        return this.func_149739_a() + this.index;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState stateIn, IBlockAccess w, BlockPos pos) {
        if (stateIn.func_177230_c() == null || stateIn.func_185904_a() == Material.field_151579_a) {
            return stateIn;
        }
        IExtendedBlockState state = (IExtendedBlockState)stateIn;
        ArrayList types = Lists.newArrayList(this.blockFaceData.getForMeta(this.func_176201_c((IBlockState)state)).getTypesUsed());
        types.add(TextureTypeRegistry.getType("CTM"));
        RenderContextList ctxList = new RenderContextList(types, w, pos);
        return state.withProperty((IUnlistedProperty)BlockCarvable.CTX_LIST, (Object)ctxList);
    }

    public static BlockPos pos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        int curIndex = 0;
        for (VariationData var : this.variations) {
            if (var == null) continue;
            ItemStack stack = new ItemStack(item, 1, curIndex);
            ++curIndex;
            list.add(stack);
        }
    }

    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager effectRenderer) {
        ClientUtil.addHitEffects(worldObj, target.func_178782_a(), target.field_178784_b);
        return true;
    }

    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        ClientUtil.addDestroyEffects(world, pos, world.func_180495_p(pos));
        return true;
    }

    private BlockStateContainer createRealBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{this.metaProp, field_176241_b, field_176243_N, field_176242_M, field_176244_O}, new IUnlistedProperty[]{BlockCarvable.CTX_LIST});
    }

    private void setupStates() {
        IBlockState state = this.getExtendedBlockState().withProperty((IUnlistedProperty)BlockCarvable.CTX_LIST, (Object)new RenderContextList()).func_177226_a((IProperty)this.metaProp, (Comparable)Integer.valueOf(0));
        state = state.func_177226_a((IProperty)this.metaProp, (Comparable)Integer.valueOf(0));
        this.func_180632_j(state);
    }

    public ExtendedBlockState getBaseExtendedState() {
        return (ExtendedBlockState)this.func_176194_O();
    }

    public IExtendedBlockState getExtendedBlockState() {
        return (IExtendedBlockState)this.getBaseExtendedState().func_177621_b();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockFaceData getBlockFaceData() {
        return this.blockFaceData;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setBlockFaceData(BlockFaceData data) {
        this.blockFaceData = data;
    }

    @Override
    public int getVariationIndex(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public int getTotalVariations() {
        return this.maxVariation + 1;
    }

    public BlockStateContainer func_176194_O() {
        return this.realBlockState;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public VariationData getVariationData(int meta) {
        return this.variations[MathHelper.func_76125_a((int)meta, (int)0, (int)(this.variations.length - 1))];
    }

    @Override
    public VariationData[] getVariations() {
        return this.variations;
    }
}

