/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import team.chisel.Chisel;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.common.carving.Carving;
import team.chisel.common.inventory.InventoryChiselSelection;
import team.chisel.common.inventory.SlotChiselInput;
import team.chisel.common.inventory.SlotChiselSelection;

public class ContainerChisel
extends Container {
    public final InventoryChiselSelection inventory;
    public InventoryPlayer playerInventory;
    int chiselSlot;
    public ItemStack chisel;
    public boolean finished;
    public ICarvingRegistry carving;
    private int totalSlots = 0;
    private EnumHand hand;

    public ContainerChisel(InventoryPlayer inventoryplayer, InventoryChiselSelection inv, EnumHand hand) {
        int i;
        this.inventory = inv;
        this.playerInventory = inventoryplayer;
        this.chiselSlot = this.playerInventory.field_70461_c;
        inv.container = this;
        this.hand = hand;
        int top = 8;
        int left = 62;
        for (i = 0; i < 60; ++i) {
            this.func_75146_a(new SlotChiselSelection(this, this.inventory, this.inventory, i, left + i % 10 * 18, top + i / 10 * 18));
        }
        this.func_75146_a(new SlotChiselInput(this, this.inventory, 60, 24, 24));
        top += 112;
        left += 9;
        for (i = 0; i < 27; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryplayer, i + 9, left + i % 9 * 18, top + i / 9 * 18));
        }
        top += 58;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryplayer, i, left + i % 9 * 18, top + i / 9 * 18));
        }
        this.chisel = inventoryplayer.field_70458_d.func_184586_b(hand);
        if (this.chisel != null && this.chisel.func_77978_p() != null) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)this.chisel.func_77978_p().func_74775_l("chiselTarget"));
            this.inventory.func_70299_a(60, stack);
        }
        Chisel.debug("There are " + this.totalSlots + " slots but list is " + this.field_75151_b.size());
        this.carving = Carving.chisel;
        this.inventory.updateItems();
    }

    protected Slot func_75146_a(Slot slotIn) {
        ++this.totalSlots;
        return super.func_75146_a(slotIn);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (clickTypeIn != ClickType.QUICK_CRAFT) {
            int clickedSlot = slotId - this.inventory.func_70302_i_() - 27;
            Chisel.debug("Slot clicked is " + slotId + " and slot length is " + this.field_75151_b.size());
            try {
                Slot slot = (Slot)this.field_75151_b.get(slotId);
                Chisel.debug("Slot is " + slot);
            }
            catch (Exception exception) {
                Chisel.debug("Exception getting slot");
                exception.printStackTrace();
            }
            if (this.hand == EnumHand.MAIN_HAND && (clickedSlot == this.chiselSlot || clickTypeIn == ClickType.SWAP && dragType == this.chiselSlot)) {
                return null;
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public void func_75134_a(EntityPlayer entityplayer) {
        this.inventory.clearItems();
        super.func_75134_a(entityplayer);
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.inventory.func_70300_a(entityplayer);
    }

    public ItemStack func_82846_b(EntityPlayer entity, int slotIdx) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIdx);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slotIdx > 60) {
                if (!this.func_75135_a(itemstack1, 60, 61, false)) {
                    return null;
                }
            } else {
                if (slotIdx < 61 && itemstack1 != null) {
                    entity.field_71071_by.func_70437_b(itemstack1.func_77946_l());
                    slot.func_82870_a(entity, itemstack1);
                    itemstack1 = entity.field_71071_by.func_70445_o();
                    entity.field_71071_by.func_70437_b(null);
                }
                if (!this.func_75135_a(itemstack1, 61, 97, true)) {
                    return null;
                }
            }
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            if (slotIdx >= 60) {
                slot.func_82870_a(entity, itemstack1);
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
                return null;
            }
        }
        return itemstack;
    }

    public void onChiselSlotChanged() {
        ItemStack stack = this.playerInventory.field_70462_a[this.chiselSlot];
        if (!(this.hand != EnumHand.MAIN_HAND || stack != null && stack.func_77969_a(this.chisel))) {
            this.finished = true;
        }
        if (this.finished) {
            return;
        }
        if (!this.chisel.func_77942_o()) {
            this.chisel.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound targetTag = new NBTTagCompound();
        if (this.inventory.getStackInSpecialSlot() != null) {
            this.inventory.getStackInSpecialSlot().func_77955_b(targetTag);
        }
        this.chisel.func_77978_p().func_74782_a("chiselTarget", (NBTBase)targetTag);
    }

    public EnumHand getHand() {
        return this.hand;
    }
}

