/*
 * Decompiled with CFR 0.152.
 */
package techreborn.manual.designer;

import java.io.File;
import java.net.URL;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.util.BuilderFactory;
import techreborn.manual.designer.ManualCatergories;
import techreborn.manual.designer.fileUtils.SaveSystem;
import techreborn.manual.designer.windows.MainWindowController;
import techreborn.manual.saveFormat.Entry;

public class ManualDesigner
extends Application {
    public static Stage stage;

    public static void main(String[] args) {
        ManualDesigner.launch((String[])args);
    }

    public void start(Stage primaryStage) throws Exception {
        stage = primaryStage;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL fxmlUrl = classLoader.getResource("assets/techreborn/designer/mainWindow.fxml");
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setLocation(fxmlUrl);
        fxmlLoader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory());
        Parent root = (Parent)fxmlLoader.load(fxmlUrl.openStream());
        Scene scene = new Scene(root, 900.0, 550.0);
        primaryStage.setTitle("TechReborn Manual Designer");
        primaryStage.setScene(scene);
        primaryStage.show();
        final MainWindowController controller = (MainWindowController)fxmlLoader.getController();
        ManualCatergories.contents = new TreeItem((Object)"Contents");
        ManualCatergories.contents.setExpanded(true);
        ManualCatergories.blocks = new TreeItem((Object)"Blocks");
        ManualCatergories.contents.getChildren().add(ManualCatergories.blocks);
        ManualCatergories.items = new TreeItem((Object)"Items");
        ManualCatergories.contents.getChildren().add(ManualCatergories.items);
        controller.treeList.setRoot(ManualCatergories.contents);
        controller.treeList.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                TreeItem selectedItem = (TreeItem)newValue;
                boolean isValid = !SaveSystem.entries.containsKey(selectedItem);
                controller.textInput.setDisable(isValid);
                controller.nameTextArea.setDisable(isValid);
                if (!isValid && SaveSystem.entries.containsKey(selectedItem)) {
                    Entry entry = SaveSystem.entries.get(selectedItem);
                    controller.pageimage.setVisible(false);
                    if (entry.data != null && entry.data.data != null) {
                        if (entry.data.data.containsKey("text")) {
                            controller.textInput.setText(entry.data.data.get("text"));
                        }
                        if (entry.data.data.containsKey("image")) {
                            File image;
                            File imagesDir;
                            controller.imageTextArea.setText(entry.data.data.get("image"));
                            if (SaveSystem.lastSave != null && (imagesDir = new File(SaveSystem.lastSave, "images")).exists() && (image = new File(imagesDir, entry.data.data.get("image") + ".png")).exists()) {
                                controller.pageimage.setImage(new Image(image.toURI().toString()));
                                controller.pageimage.setVisible(true);
                            }
                        } else {
                            controller.imageTextArea.setText("");
                        }
                    } else {
                        controller.textInput.setText("");
                        controller.imageTextArea.setText("");
                    }
                    if (entry.type.equalsIgnoreCase("image")) {
                        controller.imageTextArea.setDisable(false);
                    } else {
                        controller.imageTextArea.setDisable(true);
                    }
                    controller.infoLabel.setText("Settings: " + entry.type);
                    controller.nameTextArea.setText(entry.registryName);
                }
            }
        });
        controller.textInput.setDisable(false);
        controller.nameTextArea.setDisable(false);
        controller.image.setImage(new Image("assets/techreborn/textures/manual/gui/manual.png"));
        controller.image.setPreserveRatio(true);
        controller.image.setSmooth(true);
        controller.image.setCache(true);
        controller.image.setFitHeight(1000.0);
        controller.image.setFitWidth(1000.0);
        controller.image.fitWidthProperty().bind((ObservableValue)controller.renderPane.widthProperty());
        controller.image.fitHeightProperty().bind((ObservableValue)controller.renderPane.heightProperty());
        controller.pageimage.setPreserveRatio(true);
        controller.pageimage.setSmooth(true);
        controller.pageimage.setCache(true);
        controller.pageimage.setFitHeight(1000.0);
        controller.pageimage.setFitWidth(1000.0);
        controller.pageimage.fitWidthProperty().bind((ObservableValue)controller.renderPane.widthProperty());
        controller.pageimage.fitHeightProperty().bind((ObservableValue)controller.renderPane.heightProperty());
        controller.load();
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle("Info Dialog");
        alert.setHeaderText("This is not how to run the mod!");
        alert.setContentText("If you are trying to play with TechReborn in you minecraft world, this is NOT how you do it. You have the wrong jar file or you are doing something very wrong. Go and download the universal jar file and put it in the mods folder");
        alert.show();
    }
}

