/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import team.chisel.api.render.IChiselFace;
import team.chisel.api.render.IChiselTexture;

public final class ChiselFace
implements IChiselFace {
    private List<IChiselTexture<?>> textureList;
    private TextureAtlasSprite particle;
    private List<IChiselFace> childFaces;
    private BlockRenderLayer layer;

    public ChiselFace(ResourceLocation location) {
        this(new ArrayList(), new ArrayList<IChiselFace>());
    }

    public ChiselFace(ResourceLocation location, BlockRenderLayer layer) {
        this(location);
        this.setLayer(layer);
    }

    public ChiselFace(List<IChiselTexture<?>> textureList, List<IChiselFace> childFaces) {
        this.textureList = textureList;
        this.childFaces = childFaces;
    }

    @Override
    public List<IChiselTexture<?>> getTextureList() {
        ArrayList list = new ArrayList();
        list.addAll(this.textureList);
        for (IChiselFace face : this.childFaces) {
            list.addAll(face.getTextureList());
        }
        return list;
    }

    public void addTexture(IChiselTexture<?> texture) {
        this.textureList.add(texture);
    }

    public void addChildFace(IChiselFace face) {
        this.childFaces.add(face);
    }

    public boolean removeTexture(IChiselTexture<?> texture) {
        return this.textureList.remove(texture);
    }

    public boolean removeChildFace(IChiselFace face) {
        return this.childFaces.remove(face);
    }

    @Override
    public TextureAtlasSprite getParticle() {
        if (this.particle == null) {
            this.particle = this.textureList.get(0) != null ? this.textureList.get(0).getParticle() : this.childFaces.get(0).getParticle();
        }
        return this.particle;
    }

    public void setParticle(TextureAtlasSprite sprite) {
        this.particle = sprite;
    }

    public void setLayer(BlockRenderLayer layer) {
        this.layer = layer;
    }

    @Override
    public BlockRenderLayer getLayer() {
        return this.layer;
    }
}

