/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import team.chisel.client.render.ctm.CTM;
import team.chisel.common.util.Dir;

public enum ConnectionLocations {
    UP(Dir.TOP),
    DOWN(Dir.BOTTOM),
    NORTH(EnumFacing.EAST, Dir.RIGHT),
    SOUTH(EnumFacing.EAST, Dir.LEFT),
    EAST(Dir.RIGHT),
    WEST(Dir.LEFT),
    NORTH_EAST(EnumFacing.UP, Dir.TOP_RIGHT),
    NORTH_WEST(EnumFacing.UP, Dir.TOP_LEFT),
    SOUTH_EAST(EnumFacing.UP, Dir.BOTTOM_RIGHT),
    SOUTH_WEST(EnumFacing.UP, Dir.BOTTOM_LEFT),
    NORTH_UP(EnumFacing.EAST, Dir.TOP_RIGHT),
    NORTH_DOWN(EnumFacing.EAST, Dir.BOTTOM_RIGHT),
    SOUTH_UP(EnumFacing.EAST, Dir.TOP_LEFT),
    SOUTH_DOWN(EnumFacing.EAST, Dir.BOTTOM_LEFT),
    EAST_UP(Dir.TOP_RIGHT),
    EAST_DOWN(Dir.BOTTOM_RIGHT),
    WEST_UP(Dir.TOP_LEFT),
    WEST_DOWN(Dir.BOTTOM_LEFT),
    NORTH_EAST_UP(EnumFacing.EAST, Dir.TOP_RIGHT, true),
    NORTH_EAST_DOWN(EnumFacing.EAST, Dir.BOTTOM_RIGHT, true),
    SOUTH_EAST_UP(EnumFacing.EAST, Dir.TOP_LEFT, true),
    SOUTH_EAST_DOWN(EnumFacing.EAST, Dir.BOTTOM_LEFT, true),
    SOUTH_WEST_UP(EnumFacing.WEST, Dir.TOP_LEFT, true),
    SOUTH_WEST_DOWN(EnumFacing.WEST, Dir.BOTTOM_LEFT, true),
    NORTH_WEST_UP(EnumFacing.WEST, Dir.TOP_RIGHT, true),
    NORTH_WEST_DOWN(EnumFacing.WEST, Dir.BOTTOM_RIGHT, true),
    UP_UP(EnumFacing.UP, null, true),
    DOWN_DOWN(EnumFacing.DOWN, null, true),
    NORTH_NORTH(EnumFacing.NORTH, null, true),
    SOUTH_SOUTH(EnumFacing.SOUTH, null, true),
    EAST_EAST(EnumFacing.EAST, null, true),
    WEST_WEST(EnumFacing.WEST, null, true);

    public static final ConnectionLocations[] VALUES;
    private EnumFacing normal;
    private Dir dir;
    private boolean offset;

    private ConnectionLocations(Dir dir) {
        this(EnumFacing.SOUTH, dir);
    }

    private ConnectionLocations(Dir dir, boolean offset) {
        this(EnumFacing.SOUTH, dir, offset);
    }

    private ConnectionLocations(EnumFacing normal, Dir dir) {
        this(normal, dir, false);
    }

    private ConnectionLocations(EnumFacing normal, Dir dir, boolean offset) {
        this.normal = normal;
        this.dir = dir;
        this.offset = offset;
    }

    public Dir getDirForSide(EnumFacing facing) {
        return this.dir == null ? null : this.dir.relativize(facing);
    }

    public EnumFacing clipOrDestroy(EnumFacing direction) {
        EnumFacing[] dirs;
        EnumFacing[] enumFacingArray;
        if (this.dir == null) {
            EnumFacing[] enumFacingArray2 = new EnumFacing[2];
            enumFacingArray2[0] = this.normal;
            enumFacingArray = enumFacingArray2;
            enumFacingArray2[1] = this.normal;
        } else {
            enumFacingArray = dirs = this.dir.getNormalizedDirs(direction);
        }
        if (dirs[0] == direction) {
            return dirs.length > 1 ? dirs[1] : null;
        }
        if (dirs.length > 1 && dirs[1] == direction) {
            return dirs[0];
        }
        return null;
    }

    public BlockPos transform(BlockPos pos) {
        if (this.dir != null) {
            for (EnumFacing facing : this.dir.getNormalizedDirs(this.normal)) {
                pos = pos.func_177972_a(facing);
            }
        } else {
            pos = pos.func_177972_a(this.normal);
        }
        if (this.offset) {
            pos = pos.func_177972_a(this.normal);
        }
        return pos;
    }

    public static ConnectionLocations fromFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
        }
        return NORTH;
    }

    public static EnumFacing toFacing(ConnectionLocations loc) {
        switch (loc) {
            case NORTH: {
                return EnumFacing.NORTH;
            }
            case SOUTH: {
                return EnumFacing.SOUTH;
            }
            case EAST: {
                return EnumFacing.EAST;
            }
            case WEST: {
                return EnumFacing.WEST;
            }
            case UP: {
                return EnumFacing.UP;
            }
            case DOWN: {
                return EnumFacing.DOWN;
            }
        }
        return EnumFacing.NORTH;
    }

    public static List<ConnectionLocations> decode(long data) {
        ArrayList<ConnectionLocations> list = new ArrayList<ConnectionLocations>();
        for (ConnectionLocations loc : ConnectionLocations.values()) {
            if ((1L & data >> loc.ordinal()) == 0L) continue;
            list.add(loc);
        }
        return list;
    }

    public long getMask() {
        return 1 << this.ordinal();
    }

    public static List<ConnectionLocations> getConnections(IBlockAccess world, BlockPos pos) {
        ArrayList<ConnectionLocations> locs = new ArrayList<ConnectionLocations>();
        for (ConnectionLocations loc : VALUES) {
            BlockPos second = loc.transform(pos);
            if (!world.func_180495_p(pos).equals(CTM.getBlockOrFacade(world, second, null))) continue;
            locs.add(loc);
        }
        return locs;
    }

    public static long getData(IBlockAccess world, BlockPos pos) {
        List<ConnectionLocations> locs = ConnectionLocations.getConnections(world, pos);
        long data = 0L;
        for (ConnectionLocations loc : locs) {
            data |= loc.getMask();
        }
        return data;
    }

    static {
        VALUES = ConnectionLocations.values();
    }
}

