/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelBlockDefinition;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import team.chisel.client.render.ModelChisel;

public class ModelLoaderChisel
implements ICustomModelLoader {
    private static final String DEFAULT_MODEL = "{\"model\": { \"model\": \"cube\" }, \"face\":\"%s\"}";
    private final Gson gson = ModelBlockDefinition.field_178333_a;
    private IResourceManager manager;
    private Map<ResourceLocation, ModelChisel> loadedModels = Maps.newHashMap();

    public void func_110549_a(IResourceManager resourceManager) {
        this.manager = resourceManager;
        this.loadedModels.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation.func_110624_b().equals("ctm");
    }

    public IModel loadModel(ResourceLocation modelLocation) throws IOException {
        this.loadedModels.computeIfAbsent(modelLocation, this::loadFromFile);
        ModelChisel model = this.loadedModels.get(modelLocation);
        if (model != null) {
            model.load();
        }
        return model;
    }

    private ModelChisel loadFromFile(ResourceLocation res) {
        String domain = res.func_110623_a();
        String path = "models/block/" + domain.substring(domain.indexOf(":") + 1, domain.length());
        domain = domain.substring(0, domain.indexOf(":"));
        domain = domain.substring(domain.lastIndexOf("/") + 1, domain.length());
        res = new ResourceLocation(domain, path);
        try {
            IResource resource = this.manager.func_110536_a(res);
            return (ModelChisel)this.gson.fromJson((Reader)new InputStreamReader(resource.func_110527_b()), ModelChisel.class);
        }
        catch (FileNotFoundException f) {
            return (ModelChisel)this.gson.fromJson(String.format(DEFAULT_MODEL, res.toString().replace("models/block/", "").replace(".json", ".cf")), ModelChisel.class);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

